/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpReceiver;
import com.facebook.presto.jdbc.internal.jetty.client.HttpSender;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpReceiverOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpSenderOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpFields;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeaderValue;
import com.facebook.presto.jdbc.internal.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSender getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void release() {
        this.connection.release();
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        boolean close;
        super.exchangeTerminated(exchange, result);
        Response response = result.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        boolean bl = close = result.isFailed() || this.receiver.isShutdown();
        if (!close) {
            close = response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0 ? !responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString()) : responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        }
        if (close) {
            this.connection.close();
        } else {
            this.release();
        }
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

