/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.classloader;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorIndex;
import com.facebook.presto.jdbc.internal.spi.ConnectorIndexHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorIndexResolver;
import com.facebook.presto.jdbc.internal.spi.ConnectorResolvedIndex;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableHandle;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.jdbc.internal.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ClassLoaderSafeConnectorIndexResolver
implements ConnectorIndexResolver {
    private final ConnectorIndexResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorIndexResolver(ConnectorIndexResolver delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public ConnectorResolvedIndex resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorResolvedIndex connectorResolvedIndex = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return connectorResolvedIndex;
        }
    }

    @Override
    public ConnectorResolvedIndex resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorResolvedIndex connectorResolvedIndex = this.delegate.resolveIndex(session, tableHandle, indexableColumns, tupleDomain);
            return connectorResolvedIndex;
        }
    }

    @Override
    public ConnectorIndex getIndex(ConnectorSession session, ConnectorIndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorIndex connectorIndex = this.delegate.getIndex(session, indexHandle, lookupSchema, outputSchema);
            return connectorIndex;
        }
    }
}

