/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.slice;

import com.facebook.presto.jdbc.internal.airlift.slice.Preconditions;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class BasicSliceOutput
extends SliceOutput {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BasicSliceOutput.class).instanceSize();
    private final Slice slice;
    private int size;

    protected BasicSliceOutput(Slice slice) {
        this.slice = Preconditions.checkNotNull(slice, "slice is null");
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getRetainedSize() {
        return this.slice.getRetainedSize() + INSTANCE_SIZE;
    }

    @Override
    public boolean isWritable() {
        return this.writableBytes() > 0;
    }

    @Override
    public int writableBytes() {
        return this.slice.length() - this.size;
    }

    @Override
    public void writeByte(int value) {
        this.slice.setByte(this.size, value);
        ++this.size;
    }

    @Override
    public void writeShort(int value) {
        this.slice.setShort(this.size, value);
        this.size += 2;
    }

    @Override
    public void writeInt(int value) {
        this.slice.setInt(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeLong(long value) {
        this.slice.setLong(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeFloat(float value) {
        this.slice.setFloat(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeDouble(double value) {
        this.slice.setDouble(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(InputStream in, int length) throws IOException {
        this.slice.setBytes(this.size, in, length);
        this.size += length;
    }

    @Override
    public BasicSliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.write(source, sourceIndex, length);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        return this.slice.slice(0, this.size);
    }

    @Override
    public Slice getUnderlyingSlice() {
        return this.slice;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BasicSliceOutput{");
        builder.append("size=").append(this.size);
        builder.append(", capacity=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    @Override
    public String toString(Charset charset) {
        return this.slice.toString(0, this.size, charset);
    }
}

