/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.jdk8;

import com.facebook.presto.jdbc.internal.jackson.databind.BeanDescription;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationConfig;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.Deserializers;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.type.TypeFactory;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalDoubleDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalIntDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.jdk8.OptionalLongDeserializer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class Jdk8Deserializers
extends Deserializers.Base {
    Jdk8Deserializers() {
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw == Optional.class) {
            JavaType[] types = config.getTypeFactory().findTypeParameters(type, Optional.class);
            JavaType refType = types == null ? TypeFactory.unknownType() : types[0];
            JsonDeserializer valueDeser = (JsonDeserializer)type.getValueHandler();
            TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
            if (typeDeser == null) {
                try {
                    typeDeser = config.findTypeDeserializer(refType);
                }
                catch (NoSuchMethodError e) {
                    typeDeser = null;
                }
            }
            return new OptionalDeserializer(type, refType, typeDeser, valueDeser);
        }
        if (raw == OptionalInt.class) {
            return OptionalIntDeserializer.INSTANCE;
        }
        if (raw == OptionalLong.class) {
            return OptionalLongDeserializer.INSTANCE;
        }
        if (raw == OptionalDouble.class) {
            return OptionalDoubleDeserializer.INSTANCE;
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

