/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.transaction;

public enum IsolationLevel {
    SERIALIZABLE,
    REPEATABLE_READ,
    READ_COMMITTED,
    READ_UNCOMMITTED;


    public boolean meetsRequirementOf(IsolationLevel requirement) {
        switch (this) {
            case READ_UNCOMMITTED: {
                return requirement == READ_UNCOMMITTED;
            }
            case READ_COMMITTED: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED;
            }
            case REPEATABLE_READ: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED || requirement == REPEATABLE_READ;
            }
            case SERIALIZABLE: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unhandled isolation level: " + (Object)((Object)this)));
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }
}

