/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonNode;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.facebook.presto.jdbc.internal.joda.time.Days;
import com.facebook.presto.jdbc.internal.joda.time.Hours;
import com.facebook.presto.jdbc.internal.joda.time.Minutes;
import com.facebook.presto.jdbc.internal.joda.time.Months;
import com.facebook.presto.jdbc.internal.joda.time.ReadablePeriod;
import com.facebook.presto.jdbc.internal.joda.time.Seconds;
import com.facebook.presto.jdbc.internal.joda.time.Weeks;
import com.facebook.presto.jdbc.internal.joda.time.Years;
import java.io.IOException;

public class ReadablePeriodDeserializer
extends JodaDeserializerBase<ReadablePeriod> {
    private static final long serialVersionUID = 1L;

    public ReadablePeriodDeserializer() {
        super(ReadablePeriod.class);
    }

    @Override
    public ReadablePeriod deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode treeNode = (JsonNode)jsonParser.readValueAsTree();
        String periodType = treeNode.path("fieldType").path("name").asText();
        String periodName = treeNode.path("periodType").path("name").asText();
        int periodValue = treeNode.path(periodType).asInt();
        if (periodName.equals("Seconds")) {
            return Seconds.seconds(periodValue);
        }
        if (periodName.equals("Minutes")) {
            return Minutes.minutes(periodValue);
        }
        if (periodName.equals("Hours")) {
            return Hours.hours(periodValue);
        }
        if (periodName.equals("Days")) {
            return Days.days(periodValue);
        }
        if (periodName.equals("Weeks")) {
            return Weeks.weeks(periodValue);
        }
        if (periodName.equals("Months")) {
            return Months.months(periodValue);
        }
        if (periodName.equals("Years")) {
            return Years.years(periodValue);
        }
        throw ctxt.mappingException("Don't know how to deserialize ReadablePeriod using periodName '" + periodName + "'");
    }
}

