/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.DuplexConnectionPool;
import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.SendFailure;
import com.facebook.presto.jdbc.internal.jetty.client.api.Connection;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.annotation.ManagedAttribute;
import com.facebook.presto.jdbc.internal.jetty.util.annotation.ManagedObject;
import com.facebook.presto.jdbc.internal.jetty.util.component.ContainerLifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Sweeper;
import java.io.IOException;
import java.util.Collections;

@ManagedObject
public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Callback {
    private DuplexConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
        this.connectionPool = this.newConnectionPool(client);
        this.addBean(this.connectionPool);
        Sweeper sweeper = client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.offer(this.connectionPool);
        }
    }

    @Override
    protected void doStart() throws Exception {
        HttpClient client = this.getHttpClient();
        this.connectionPool = this.newConnectionPool(client);
        this.addBean(this.connectionPool);
        super.doStart();
        Sweeper sweeper = client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.offer(this.connectionPool);
        }
    }

    @Override
    protected void doStop() throws Exception {
        HttpClient client = this.getHttpClient();
        Sweeper sweeper = client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.remove(this.connectionPool);
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected DuplexConnectionPool newConnectionPool(HttpClient client) {
        return new DuplexConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    @ManagedAttribute(value="The connection pool", readonly=true)
    public DuplexConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded() {
        this.send();
    }

    @Override
    public void failed(Throwable x) {
        this.abort(x);
    }

    @Override
    public void send() {
        if (this.getHttpExchanges().isEmpty()) {
            return;
        }
        this.process();
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    private void process() {
        boolean proceed;
        C connection;
        while ((connection = this.acquire()) != null && (proceed = this.process(connection))) {
        }
    }

    public boolean process(C connection) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", exchange, connection, this);
        }
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", client);
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            exchange.abort(cause);
        } else {
            SendFailure result = this.send(connection, exchange);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send failed {} for {}", result, exchange);
                }
                if (result.retry && this.enqueue(this.getHttpExchanges(), exchange)) {
                    return true;
                }
                request.abort(result.failure);
            }
        }
        return this.getHttpExchanges().peek() != null;
    }

    protected abstract SendFailure send(C var1, HttpExchange var2);

    @Override
    public void release(Connection c) {
        HttpClient client;
        Connection connection = c;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", connection);
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send();
                } else {
                    connection.close();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", client);
            }
            connection.close();
        }
    }

    @Override
    public void close(Connection connection) {
        super.close(connection);
        boolean removed = this.connectionPool.remove(connection);
        if (this.getHttpExchanges().isEmpty()) {
            if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
                this.getHttpClient().removeDestination(this);
            }
        } else if (removed) {
            this.process();
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        ContainerLifeCycle.dump(out, indent, Collections.singletonList(this.connectionPool));
    }

    @Override
    public String toString() {
        return String.format("%s,pool=%s", super.toString(), this.connectionPool);
    }
}

