/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.predicate;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.predicate.Primitives;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeUtils;

public final class Utils {
    private Utils() {
    }

    public static Block nativeValueToBlock(Type type, Object object) {
        if (!Primitives.wrap(type.getJavaType()).isInstance(object)) {
            throw new IllegalArgumentException(String.format("Object '%s' does not match type %s", object, type.getJavaType()));
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1);
        TypeUtils.writeNativeValue(type, blockBuilder, object);
        return blockBuilder.build();
    }

    static Object blockToNativeValue(Type type, Block block) {
        return TypeUtils.readNativeValue(type, block, 0);
    }
}

