/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.classloader;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ConnectorPageSink;
import com.facebook.presto.jdbc.internal.spi.Page;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import java.util.Collection;
import java.util.Objects;

public class ClassLoaderSafeConnectorPageSink
implements ConnectorPageSink {
    private final ConnectorPageSink delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorPageSink(ConnectorPageSink delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public void appendPage(Page page, Block sampleWeightBlock) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.appendPage(page, sampleWeightBlock);
        }
    }

    @Override
    public Collection<Slice> finish() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Collection<Slice> collection = this.delegate.finish();
            return collection;
        }
    }

    @Override
    public void abort() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

