/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpConnection;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.SendFailure;
import com.facebook.presto.jdbc.internal.jetty.http.HttpVersion;
import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Session;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpChannelOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.ConcurrentHashSet;
import java.nio.channels.AsynchronousCloseException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpConnectionOverHTTP2
extends HttpConnection {
    private final Set<HttpChannel> channels = new ConcurrentHashSet<HttpChannel>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Session session;

    public HttpConnectionOverHTTP2(HttpDestination destination, Session session) {
        super(destination);
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    protected SendFailure send(HttpExchange exchange) {
        exchange.getRequest().version(HttpVersion.HTTP_2);
        this.normalizeRequest(exchange.getRequest());
        HttpChannelOverHTTP2 channel = this.newHttpChannel();
        this.channels.add(channel);
        return this.send(channel, exchange);
    }

    protected HttpChannelOverHTTP2 newHttpChannel() {
        return new HttpChannelOverHTTP2(this.getHttpDestination(), this, this.getSession());
    }

    protected void release(HttpChannel channel) {
        this.channels.remove(channel);
        this.getHttpDestination().release(this);
    }

    @Override
    public boolean onIdleTimeout(long idleTimeout) {
        boolean close = super.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(new TimeoutException("idle_timeout"));
        }
        return false;
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().close(this);
            this.abort(failure);
            this.session.close(ErrorCode.NO_ERROR.code, failure.getMessage(), Callback.NOOP);
        }
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.channels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.channels.clear();
    }

    @Override
    public String toString() {
        return String.format("%s@%h[%s]", this.getClass().getSimpleName(), this, this.session);
    }
}

