/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractVariableWidthType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignatureParameter;
import java.util.Collections;
import java.util.Objects;

public final class CharType
extends AbstractVariableWidthType {
    public static final int MAX_LENGTH = 65536;
    private final int length;

    public static CharType createCharType(long length) {
        return new CharType(length);
    }

    private CharType(long length) {
        super(new TypeSignature("char", Collections.singletonList(TypeSignatureParameter.of(length))), Slice.class);
        if (length < 0L || length > 65536L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("CHAR length scale must be in range [0, %s]", 65536));
        }
        this.length = (int)length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(this.length);
        String value = block.getSlice(position, 0, block.getLength(position)).toStringUtf8();
        builder.append(value);
        for (int i = value.length(); i < this.length; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, Slices.utf8Slice(value));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharType other = (CharType)o;
        return Objects.equals(this.length, other.length);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length);
    }

    @Override
    public String getDisplayName() {
        return this.getTypeSignature().toString();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }
}

