/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.block.LongArrayBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class LongArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<LongArrayBlockEncoding> FACTORY = new LongArrayBlockEncodingFactory();
    private static final String NAME = "LONG_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeLong(block.getLong(position, 0));
        }
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        long[] values = new long[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull[position]) continue;
            values[position] = sliceInput.readLong();
        }
        return new LongArrayBlock(positionCount, valueIsNull, values);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class LongArrayBlockEncodingFactory
    implements BlockEncodingFactory<LongArrayBlockEncoding> {
        @Override
        public String getName() {
            return LongArrayBlockEncoding.NAME;
        }

        @Override
        public LongArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new LongArrayBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, LongArrayBlockEncoding blockEncoding) {
        }
    }
}

