/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.memory;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.QueryId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MemoryPoolInfo {
    private final long maxBytes;
    private final long freeBytes;
    private final Map<QueryId, Long> queryMemoryReservations;

    @JsonCreator
    public MemoryPoolInfo(@JsonProperty(value="maxBytes") long maxBytes, @JsonProperty(value="freeBytes") long freeBytes, @JsonProperty(value="queryMemoryReservations") Map<QueryId, Long> queryMemoryReservations) {
        this.maxBytes = maxBytes;
        this.freeBytes = freeBytes;
        this.queryMemoryReservations = Collections.unmodifiableMap(new HashMap<QueryId, Long>(queryMemoryReservations));
    }

    @JsonProperty
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @JsonProperty
    public long getFreeBytes() {
        return this.freeBytes;
    }

    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryReservations() {
        return this.queryMemoryReservations;
    }

    public String toString() {
        return String.format("maxBytes=%s,freeBytes=%s", this.maxBytes, this.freeBytes);
    }
}

