/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.client.NodeVersion;
import com.facebook.presto.jdbc.internal.guava.base.MoreObjects;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ServerInfo {
    private final NodeVersion nodeVersion;
    private final String environment;
    private final boolean coordinator;
    private final Optional<Duration> uptime;

    @JsonCreator
    public ServerInfo(@JsonProperty(value="nodeVersion") NodeVersion nodeVersion, @JsonProperty(value="environment") String environment, @JsonProperty(value="coordinator") boolean coordinator, @JsonProperty(value="uptime") Optional<Duration> uptime) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.coordinator = Objects.requireNonNull(Boolean.valueOf(coordinator), "coordinator is null");
        this.uptime = Objects.requireNonNull(uptime, "uptime is null");
    }

    @JsonProperty
    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public boolean isCoordinator() {
        return this.coordinator;
    }

    @JsonProperty
    public Optional<Duration> getUptime() {
        return this.uptime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return Objects.equals(this.nodeVersion, that.nodeVersion) && Objects.equals(this.environment, that.environment);
    }

    public int hashCode() {
        return Objects.hash(this.nodeVersion, this.environment);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("nodeVersion", this.nodeVersion).add("environment", this.environment).add("coordinator", this.coordinator).add("uptime", this.uptime.orElse(null)).omitNullValues().toString();
    }
}

