/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.spi.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractArrayBlock
implements Block {
    protected abstract Block getValues();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    protected abstract boolean[] getValueIsNull();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public BlockEncoding getEncoding() {
        return new ArrayBlockEncoding(this.getValues().getEncoding());
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        int[] newOffsets = new int[positions.size() + 1];
        boolean[] newValueIsNull = new boolean[positions.size()];
        ArrayList<Integer> valuesPositions = new ArrayList<Integer>();
        int newPosition = 0;
        for (int position : positions) {
            if (this.isNull(position)) {
                newValueIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int valuesStartOffset = this.getOffset(position);
                int valuesEndOffset = this.getOffset(position + 1);
                int valuesLength = valuesEndOffset - valuesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + valuesLength;
                for (int elementIndex = valuesStartOffset; elementIndex < valuesEndOffset; ++elementIndex) {
                    valuesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        Block newValues = this.getValues().copyPositions(valuesPositions);
        return new ArrayBlock(positions.size(), newValueIsNull, newOffsets, newValues);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        if (position == 0 && length == positionCount) {
            return this;
        }
        return new ArrayBlock(position + this.getOffsetBase(), length, this.getValueIsNull(), this.getOffsets(), this.getValues());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        int valueStart = this.getOffsets()[this.getOffsetBase() + position];
        int valueEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        return this.getValues().getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newValues = this.getValues().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = new int[length + 1];
        for (int i = 1; i < newOffsets.length; ++i) {
            newOffsets[i] = this.getOffset(position + i) - startValueOffset;
        }
        boolean[] newValueIsNull = Arrays.copyOfRange(this.getValueIsNull(), position + this.getOffsetBase(), position + this.getOffsetBase() + length);
        return new ArrayBlock(length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return clazz.cast(this.getValues().getRegion(startValueOffset, endValueOffset - startValueOffset));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (this.getValues().isNull(i)) {
                entryBuilder.appendNull();
                continue;
            }
            this.getValues().writePositionTo(i, entryBuilder);
            entryBuilder.closeEntry();
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int valueLength = this.getOffset(position + 1) - startValueOffset;
        Block newValues = this.getValues().copyRegion(startValueOffset, valueLength);
        return new ArrayBlock(1, new boolean[]{this.isNull(position)}, new int[]{0, valueLength}, newValues);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.getValueIsNull()[position + this.getOffsetBase()];
    }

    public <T> T apply(ArrayBlockFunction<T> function, int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return function.apply(this.getValues(), startValueOffset, endValueOffset - startValueOffset);
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    public static interface ArrayBlockFunction<T> {
        public T apply(Block var1, int var2, int var3);
    }
}

