/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import java.util.List;

public abstract class AbstractSingleMapBlock
implements Block {
    abstract int getOffset();

    abstract Block getKeyBlock();

    abstract Block getValueBlock();

    private int getAbsolutePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
        return position + this.getOffset();
    }

    @Override
    public boolean isNull(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            if (this.getKeyBlock().isNull(position / 2)) {
                throw new IllegalStateException("Map key is null");
            }
            return false;
        }
        return this.getValueBlock().isNull(position / 2);
    }

    @Override
    public byte getByte(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getByte(position / 2, offset);
        }
        return this.getValueBlock().getByte(position / 2, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getShort(position / 2, offset);
        }
        return this.getValueBlock().getShort(position / 2, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getInt(position / 2, offset);
        }
        return this.getValueBlock().getInt(position / 2, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getLong(position / 2, offset);
        }
        return this.getValueBlock().getLong(position / 2, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getSlice(position / 2, offset, length);
        }
        return this.getValueBlock().getSlice(position / 2, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getSliceLength(position / 2);
        }
        return this.getValueBlock().getSliceLength(position / 2);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().compareTo(position / 2, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
        }
        return this.getValueBlock().compareTo(position / 2, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
        }
        return this.getValueBlock().bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
        }
        return this.getValueBlock().bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getKeyBlock().writeBytesTo(position / 2, offset, length, blockBuilder);
        } else {
            this.getValueBlock().writeBytesTo(position / 2, offset, length, blockBuilder);
        }
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
        }
        return this.getValueBlock().equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().hash(position / 2, offset, length);
        }
        return this.getValueBlock().hash(position / 2, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getObject(position / 2, clazz);
        }
        return this.getValueBlock().getObject(position / 2, clazz);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getKeyBlock().writePositionTo(position / 2, blockBuilder);
        } else {
            this.getValueBlock().writePositionTo(position / 2, blockBuilder);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getKeyBlock().getSingleValueBlock(position / 2);
        }
        return this.getValueBlock().getSingleValueBlock(position / 2);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

