/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class BlockUtil {
    private static final double BLOCK_RESET_SKEW = 1.25;
    private static final int DEFAULT_CAPACITY = 64;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private BlockUtil() {
    }

    static void checkValidPositions(List<Integer> positions, int positionCount) {
        Set invalidPositions = positions.stream().filter(position -> position >= positionCount).collect(Collectors.toSet());
        if (!invalidPositions.isEmpty()) {
            throw new IllegalArgumentException("Invalid positions " + invalidPositions + " in block with " + positionCount + " positions");
        }
    }

    static void checkValidRegion(int positionCount, int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
    }

    static int calculateNewArraySize(int currentSize) {
        long newSize = currentSize + (currentSize >> 1);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L && (newSize = 0x7FFFFFF7L) == (long)currentSize) {
            throw new IllegalArgumentException("Can not grow array beyond 2147483639");
        }
        return (int)newSize;
    }

    static int calculateBlockResetSize(int currentSize) {
        long newSize = (long)Math.ceil((double)currentSize * 1.25);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF7L) {
            newSize = 0x7FFFFFF7L;
        }
        return (int)newSize;
    }

    static int calculateBlockResetBytes(int currentBytes) {
        long newBytes = (long)Math.ceil((double)currentBytes * 1.25);
        if (newBytes > 0x7FFFFFF7L) {
            return 0x7FFFFFF7;
        }
        return (int)newBytes;
    }
}

