/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.MapBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.MapType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;

public class MapBlock
extends AbstractMapBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    private final boolean[] mapIsNull;
    private final int[] offsets;
    private final Block keyBlock;
    private final Block valueBlock;
    private final int[] hashTables;
    private volatile long sizeInBytes;
    private final long retainedSizeInBytes;

    MapBlock(int startOffset, int positionCount, boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, int[] hashTables, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode) {
        super(keyType, keyNativeHashCode, keyBlockNativeEquals);
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.mapIsNull = mapIsNull;
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.keyBlock = Objects.requireNonNull(keyBlock, "keyBlock is null");
        this.valueBlock = Objects.requireNonNull(valueBlock, "valueBlock is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock and valueBlock has different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTables.length < keyBlock.getPositionCount() * 2) {
            throw new IllegalArgumentException(String.format("keyBlock/valueBlock size does not match hash table size: %s %s", keyBlock.getPositionCount(), hashTables.length));
        }
        this.hashTables = hashTables;
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + keyBlock.getRetainedSizeInBytes() + valueBlock.getRetainedSizeInBytes() + SizeOf.sizeOf(offsets) + SizeOf.sizeOf(mapIsNull) + SizeOf.sizeOf(hashTables);
    }

    @Override
    protected Block getKeys() {
        return this.keyBlock;
    }

    @Override
    protected Block getValues() {
        return this.valueBlock;
    }

    @Override
    protected int[] getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int entriesStart = this.offsets[this.startOffset];
        int entriesEnd = this.offsets[this.startOffset + this.positionCount];
        int entryCount = entriesEnd - entriesStart;
        this.sizeInBytes = this.keyBlock.getRegionSizeInBytes(entriesStart, entryCount) + this.valueBlock.getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)this.positionCount + 8L * (long)entryCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlock, this.keyBlock.getRetainedSizeInBytes());
        consumer.accept(this.valueBlock, this.valueBlock.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf(this.mapIsNull));
        consumer.accept(this.hashTables, SizeOf.sizeOf(this.hashTables));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    public static MapBlock fromKeyValueBlock(boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, MapType mapType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode) {
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock position count does not match valueBlock position count. %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        int elementCount = keyBlock.getPositionCount();
        if (mapIsNull.length != offsets.length - 1) {
            throw new IllegalArgumentException(String.format("mapIsNull.length-1 does not match offsets.length. %s %s", mapIsNull.length - 1, offsets.length));
        }
        int mapCount = mapIsNull.length;
        if (offsets[mapCount] != elementCount) {
            throw new IllegalArgumentException(String.format("Last element of offsets does not match keyBlock position count. %s %s", offsets[mapCount], keyBlock.getPositionCount()));
        }
        int[] hashTables = new int[elementCount * 2];
        Arrays.fill(hashTables, -1);
        for (int i = 0; i < mapCount; ++i) {
            int keyOffset = offsets[i];
            int keyCount = offsets[i + 1] - keyOffset;
            if (keyCount < 0) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, offsets[i], i + 1, offsets[i + 1]));
            }
            MapBlockBuilder.buildHashTable(keyBlock, keyOffset, keyCount, keyBlockHashCode, hashTables, keyOffset * 2, keyCount * 2);
        }
        return new MapBlock(0, mapCount, mapIsNull, offsets, keyBlock, valueBlock, hashTables, mapType.getKeyType(), keyBlockNativeEquals, keyNativeHashCode);
    }
}

