/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.spi.block.MapBlock;
import com.facebook.presto.jdbc.internal.spi.block.MethodHandleUtil;
import com.facebook.presto.jdbc.internal.spi.function.OperatorType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;
import com.facebook.presto.jdbc.internal.spi.type.TypeSerde;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class MapBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<MapBlockEncoding> FACTORY = new MapBlockEncodingFactory();
    private static final String NAME = "MAP";
    private final Type keyType;
    private final MethodHandle keyNativeHashCode;
    private final MethodHandle keyBlockNativeEquals;
    private final BlockEncoding keyBlockEncoding;
    private final BlockEncoding valueBlockEncoding;

    public MapBlockEncoding(Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, BlockEncoding keyBlockEncoding, BlockEncoding valueBlockEncoding) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyNativeHashCode = keyNativeHashCode;
        this.keyBlockNativeEquals = keyBlockNativeEquals;
        this.keyBlockEncoding = Objects.requireNonNull(keyBlockEncoding, "keyBlockEncoding is null");
        this.valueBlockEncoding = Objects.requireNonNull(valueBlockEncoding, "valueBlockEncoding is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int positionCount = mapBlock.getPositionCount();
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        int[] hashTable = mapBlock.getHashTables();
        int entriesStartOffset = offsets[offsetBase];
        int entriesEndOffset = offsets[offsetBase + positionCount];
        this.keyBlockEncoding.writeBlock(sliceOutput, mapBlock.getKeys().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        this.valueBlockEncoding.writeBlock(sliceOutput, mapBlock.getValues().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        sliceOutput.appendInt((entriesEndOffset - entriesStartOffset) * 2);
        sliceOutput.writeBytes(Slices.wrappedIntArray(hashTable, entriesStartOffset * 2, (entriesEndOffset - entriesStartOffset) * 2));
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(offsets[offsetBase + position] - entriesStartOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block keyBlock = this.keyBlockEncoding.readBlock(sliceInput);
        Block valueBlock = this.valueBlockEncoding.readBlock(sliceInput);
        int[] hashTable = new int[sliceInput.readInt()];
        sliceInput.readBytes(Slices.wrappedIntArray(hashTable));
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount() || keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: key %d, value %d, hash %d", keyBlock.getPositionCount(), valueBlock.getPositionCount(), hashTable.length));
        }
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray(offsets));
        boolean[] mapIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return new MapBlock(0, positionCount, mapIsNull, offsets, keyBlock, valueBlock, hashTable, this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class MapBlockEncodingFactory
    implements BlockEncodingFactory<MapBlockEncoding> {
        @Override
        public String getName() {
            return MapBlockEncoding.NAME;
        }

        @Override
        public MapBlockEncoding readEncoding(TypeManager typeManager, BlockEncodingSerde serde, SliceInput input) {
            Type keyType = TypeSerde.readType(typeManager, input);
            MethodHandle keyNativeEquals = typeManager.resolveOperator(OperatorType.EQUAL, Arrays.asList(keyType, keyType));
            MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose(keyNativeEquals, MethodHandleUtil.nativeValueGetter(keyType));
            MethodHandle keyNativeHashCode = typeManager.resolveOperator(OperatorType.HASH_CODE, Collections.singletonList(keyType));
            BlockEncoding keyBlockEncoding = serde.readBlockEncoding(input);
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new MapBlockEncoding(keyType, keyBlockNativeEquals, keyNativeHashCode, keyBlockEncoding, valueBlockEncoding);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, MapBlockEncoding blockEncoding) {
            TypeSerde.writeType(output, blockEncoding.keyType);
            serde.writeBlockEncoding(output, blockEncoding.keyBlockEncoding);
            serde.writeBlockEncoding(output, blockEncoding.valueBlockEncoding);
        }
    }
}

