/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractSingleRowBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.SingleRowBlockEncoding;
import java.util.function.BiConsumer;

public class SingleRowBlock
extends AbstractSingleRowBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlock.class).instanceSize();
    private final Block[] fieldBlocks;

    SingleRowBlock(int cellOffset, Block[] fieldBlocks) {
        super(cellOffset, fieldBlocks.length);
        this.fieldBlocks = fieldBlocks;
    }

    @Override
    protected Block getFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    @Override
    public int getPositionCount() {
        return this.numFields;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (int i = 0; i < this.numFields; ++i) {
            sizeInBytes += this.getFieldBlock(i).getSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (int i = 0; i < this.numFields; ++i) {
            retainedSizeInBytes += this.getFieldBlock(i).getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockEncoding getEncoding() {
        BlockEncoding[] fieldBlockEncodings = new BlockEncoding[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            fieldBlockEncodings[i] = this.fieldBlocks[i].getEncoding();
        }
        return new SingleRowBlockEncoding(fieldBlockEncodings);
    }

    public int getOffset() {
        return this.startOffset;
    }

    public String toString() {
        return String.format("SingleRowBlock{numFields=%d}", this.numFields);
    }
}

