/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.memory;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.QueryId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MemoryPoolInfo {
    private final long maxBytes;
    private final long reservedBytes;
    private final long reservedRevocableBytes;
    private final Map<QueryId, Long> queryMemoryReservations;
    private final Map<QueryId, Long> queryMemoryRevocableReservations;

    @JsonCreator
    public MemoryPoolInfo(@JsonProperty(value="maxBytes") long maxBytes, @JsonProperty(value="reservedBytes") long reservedBytes, @JsonProperty(value="reservedRevocableBytes") long reservedRevocableBytes, @JsonProperty(value="queryMemoryReservations") Map<QueryId, Long> queryMemoryReservations, @JsonProperty(value="queryMemoryRevocableReservations") Map<QueryId, Long> queryMemoryRevocableReservations) {
        this.maxBytes = maxBytes;
        this.reservedBytes = reservedBytes;
        this.reservedRevocableBytes = reservedRevocableBytes;
        this.queryMemoryReservations = Collections.unmodifiableMap(new HashMap<QueryId, Long>(queryMemoryReservations));
        this.queryMemoryRevocableReservations = Collections.unmodifiableMap(new HashMap<QueryId, Long>(queryMemoryReservations));
    }

    @JsonProperty
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @JsonProperty
    public long getFreeBytes() {
        return this.maxBytes - this.reservedBytes - this.reservedRevocableBytes;
    }

    @JsonProperty
    public long getReservedBytes() {
        return this.reservedBytes;
    }

    @JsonProperty
    public long getReservedRevocableBytes() {
        return this.reservedRevocableBytes;
    }

    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryReservations() {
        return this.queryMemoryReservations;
    }

    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryRevocableReservations() {
        return this.queryMemoryRevocableReservations;
    }

    public String toString() {
        return String.format("maxBytes=%s,reservedBytes=%s,reserveRevocableBytes=%s", this.maxBytes, this.reservedBytes, this.reservedRevocableBytes);
    }
}

