/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.facebook.presto.jdbc.internal.joda.time.DateTimeZone;
import java.io.IOException;

public class DateTimeZoneDeserializer
extends JodaDeserializerBase<DateTimeZone> {
    private static final long serialVersionUID = 1L;

    public DateTimeZoneDeserializer() {
        super(DateTimeZone.class);
    }

    @Override
    public DateTimeZone deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return DateTimeZone.forOffsetHours(p.getIntValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            return DateTimeZone.forID(p.getText().trim());
        }
        return (DateTimeZone)ctxt.handleUnexpectedToken(this.handledType(), p);
    }
}

