/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Objects;
import java.util.Optional;

public final class RangeColumnStatistics {
    private final Optional<Object> lowValue;
    private final Optional<Object> highValue;
    private final Estimate fraction;
    private final Estimate dataSize;
    private final Estimate distinctValuesCount;

    private RangeColumnStatistics(Optional<Object> lowValue, Optional<Object> highValue, Estimate fraction, Estimate dataSize, Estimate distinctValuesCount) {
        this.lowValue = Objects.requireNonNull(lowValue, "lowValue can not be null");
        this.highValue = Objects.requireNonNull(highValue, "highValue can not be null");
        this.fraction = Objects.requireNonNull(fraction, "fraction can not be null");
        this.dataSize = Objects.requireNonNull(dataSize, "dataSize can not be null");
        this.distinctValuesCount = Objects.requireNonNull(distinctValuesCount, "distinctValuesCount can not be null");
    }

    public Optional<Object> getLowValue() {
        return this.lowValue;
    }

    public Optional<Object> getHighValue() {
        return this.highValue;
    }

    public Estimate getDataSize() {
        return this.dataSize;
    }

    public Estimate getFraction() {
        return this.fraction;
    }

    public Estimate getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeColumnStatistics that = (RangeColumnStatistics)o;
        return Objects.equals(this.lowValue, that.lowValue) && Objects.equals(this.highValue, that.highValue) && Objects.equals(this.fraction, that.fraction) && Objects.equals(this.dataSize, that.dataSize) && Objects.equals(this.distinctValuesCount, that.distinctValuesCount);
    }

    public int hashCode() {
        return Objects.hash(this.lowValue, this.highValue, this.fraction, this.dataSize, this.distinctValuesCount);
    }

    public String toString() {
        return "RangeColumnStatistics{lowValue=" + this.lowValue + ", highValue=" + this.highValue + ", fraction=" + this.fraction + ", dataSize=" + this.dataSize + ", distinctValuesCount=" + this.distinctValuesCount + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<Object> lowValue = Optional.empty();
        private Optional<Object> highValue = Optional.empty();
        private Estimate dataSize = Estimate.unknownValue();
        private Estimate fraction = Estimate.unknownValue();
        private Estimate distinctValuesCount = Estimate.unknownValue();

        public Builder setLowValue(Optional<Object> lowValue) {
            this.lowValue = lowValue;
            return this;
        }

        public Builder setHighValue(Optional<Object> highValue) {
            this.highValue = highValue;
            return this;
        }

        public Builder setFraction(Estimate fraction) {
            this.fraction = fraction;
            return this;
        }

        public Builder setDataSize(Estimate dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public Builder setDistinctValuesCount(Estimate distinctValuesCount) {
            this.distinctValuesCount = distinctValuesCount;
            return this;
        }

        public RangeColumnStatistics build() {
            return new RangeColumnStatistics(this.lowValue, this.highValue, this.fraction, this.dataSize, this.distinctValuesCount);
        }
    }
}

