/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.ConnectionProperties;
import com.facebook.presto.jdbc.ConnectionProperty;
import com.facebook.presto.jdbc.internal.client.ClientException;
import com.facebook.presto.jdbc.internal.client.KerberosUtil;
import com.facebook.presto.jdbc.internal.client.OkHttpUtil;
import com.facebook.presto.jdbc.internal.guava.base.Splitter;
import com.facebook.presto.jdbc.internal.guava.base.Strings;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.guava.collect.Maps;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import com.facebook.presto.jdbc.internal.okhttp3.OkHttpClient;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

final class PrestoDriverUri {
    private static final String JDBC_URL_START = "jdbc:";
    private static final Splitter QUERY_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on('=').limit(2);
    private final HostAndPort address;
    private final URI uri;
    private final Properties properties;
    private String catalog;
    private String schema;
    private final boolean useSecureConnection;

    public PrestoDriverUri(String url, Properties driverProperties) throws SQLException {
        this(PrestoDriverUri.parseDriverUrl(url), driverProperties);
    }

    private PrestoDriverUri(URI uri, Properties driverProperties) throws SQLException {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.address = HostAndPort.fromParts(uri.getHost(), uri.getPort());
        this.properties = PrestoDriverUri.mergeConnectionProperties(uri, driverProperties);
        PrestoDriverUri.validateConnectionProperties(this.properties);
        this.useSecureConnection = ConnectionProperties.SSL.getValue(this.properties).orElse(uri.getPort() == 443);
        this.initCatalogAndSchema();
    }

    public URI getJdbcUri() {
        return this.uri;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public URI getHttpUri() {
        return this.buildHttpUri();
    }

    public String getUser() throws SQLException {
        return ConnectionProperties.USER.getRequiredValue(this.properties);
    }

    public Optional<String> getApplicationNamePrefix() throws SQLException {
        return ConnectionProperties.APPLICATION_NAME_PREFIX.getValue(this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setupClient(OkHttpClient.Builder builder) throws SQLException {
        try {
            OkHttpUtil.setupCookieJar(builder);
            OkHttpUtil.setupSocksProxy(builder, ConnectionProperties.SOCKS_PROXY.getValue(this.properties));
            OkHttpUtil.setupHttpProxy(builder, ConnectionProperties.HTTP_PROXY.getValue(this.properties));
            String password = ConnectionProperties.PASSWORD.getValue(this.properties).orElse("");
            if (!password.isEmpty() && !password.equals("***empty***")) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using username/password requires SSL to be enabled");
                }
                builder.addInterceptor(OkHttpUtil.basicAuth(this.getUser(), password));
            }
            if (this.useSecureConnection) {
                OkHttpUtil.setupSsl(builder, ConnectionProperties.SSL_KEY_STORE_PATH.getValue(this.properties), ConnectionProperties.SSL_KEY_STORE_PASSWORD.getValue(this.properties), ConnectionProperties.SSL_TRUST_STORE_PATH.getValue(this.properties), ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getValue(this.properties));
            }
            if (ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME.getValue(this.properties).isPresent()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using Kerberos requires SSL to be enabled");
                }
                OkHttpUtil.setupKerberos(builder, ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME.getRequiredValue(this.properties), ConnectionProperties.KERBEROS_USE_CANONICAL_HOSTNAME.getRequiredValue(this.properties), ConnectionProperties.KERBEROS_PRINCIPAL.getValue(this.properties), ConnectionProperties.KERBEROS_CONFIG_PATH.getValue(this.properties), ConnectionProperties.KERBEROS_KEYTAB_PATH.getValue(this.properties), Optional.ofNullable(ConnectionProperties.KERBEROS_CREDENTIAL_CACHE_PATH.getValue(this.properties).orElseGet(() -> KerberosUtil.defaultCredentialCachePath().map(File::new).orElse(null))));
            }
            if (ConnectionProperties.ACCESS_TOKEN.getValue(this.properties).isPresent()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using an access token requires SSL to be enabled");
                }
                builder.addInterceptor(OkHttpUtil.tokenAuth(ConnectionProperties.ACCESS_TOKEN.getValue(this.properties).get()));
            }
        }
        catch (ClientException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SQLException("Error setting up connection", e);
        }
    }

    private static Map<String, String> parseParameters(String query) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            Iterable<String> queryArgs = QUERY_SPLITTER.split(query);
            for (String queryArg : queryArgs) {
                List<String> parts = ARG_SPLITTER.splitToList(queryArg);
                if (result.put(parts.get(0), parts.get(1)) == null) continue;
                throw new SQLException(String.format("Connection property '%s' is in URL multiple times", parts.get(0)));
            }
        }
        return result;
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        try {
            uri = new URI(url.substring(JDBC_URL_START.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private URI buildHttpUri() {
        String scheme = this.useSecureConnection ? "https" : "http";
        try {
            return new URI(scheme, null, this.address.getHost(), this.address.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void initCatalogAndSchema() throws SQLException {
        String path = this.uri.getPath();
        if (Strings.isNullOrEmpty(this.uri.getPath()) || path.equals("/")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException("Path does not start with a slash: " + this.uri);
        }
        path = path.substring(1);
        List<String> parts = Splitter.on("/").splitToList(path);
        if (parts.get(parts.size() - 1).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new SQLException("Invalid path segments in URL: " + this.uri);
        }
        if (parts.get(0).isEmpty()) {
            throw new SQLException("Catalog name is empty: " + this.uri);
        }
        this.catalog = parts.get(0);
        if (parts.size() > 1) {
            if (parts.get(1).isEmpty()) {
                throw new SQLException("Schema name is empty: " + this.uri);
            }
            this.schema = parts.get(1);
        }
    }

    private static Properties mergeConnectionProperties(URI uri, Properties driverProperties) throws SQLException {
        Map<String, String> defaults = ConnectionProperties.getDefaults();
        Map<String, String> urlProperties = PrestoDriverUri.parseParameters(uri.getQuery());
        ImmutableMap<String, String> suppliedProperties = Maps.fromProperties(driverProperties);
        for (String key : urlProperties.keySet()) {
            if (!suppliedProperties.containsKey(key)) continue;
            throw new SQLException(String.format("Connection property '%s' is both in the URL and an argument", key));
        }
        Properties result = new Properties();
        PrestoDriverUri.setProperties(result, defaults);
        PrestoDriverUri.setProperties(result, urlProperties);
        PrestoDriverUri.setProperties(result, suppliedProperties);
        return result;
    }

    private static void setProperties(Properties properties, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void validateConnectionProperties(Properties connectionProperties) throws SQLException {
        for (String string : connectionProperties.stringPropertyNames()) {
            if (ConnectionProperties.forKey(string) != null) continue;
            throw new SQLException(String.format("Unrecognized connection property '%s'", string));
        }
        for (ConnectionProperty connectionProperty : ConnectionProperties.allProperties()) {
            connectionProperty.validate(connectionProperties);
        }
    }
}

