/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.type.TimeZoneNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public final class TimeZoneKey {
    public static final TimeZoneKey UTC_KEY = new TimeZoneKey("UTC", 0);
    public static final short MAX_TIME_ZONE_KEY;
    private static final Map<String, TimeZoneKey> ZONE_ID_TO_KEY;
    private static final Set<TimeZoneKey> ZONE_KEYS;
    private static final TimeZoneKey[] TIME_ZONE_KEYS;
    private static final short OFFSET_TIME_ZONE_MIN = -840;
    private static final short OFFSET_TIME_ZONE_MAX = 840;
    private static final TimeZoneKey[] OFFSET_TIME_ZONE_KEYS;
    private final String id;
    private final short key;

    public static Set<TimeZoneKey> getTimeZoneKeys() {
        return ZONE_KEYS;
    }

    @JsonCreator
    public static TimeZoneKey getTimeZoneKey(short timeZoneKey) {
        TimeZoneKey.checkArgument(timeZoneKey < TIME_ZONE_KEYS.length && TIME_ZONE_KEYS[timeZoneKey] != null, "Invalid time zone key %d", timeZoneKey);
        return TIME_ZONE_KEYS[timeZoneKey];
    }

    public static TimeZoneKey getTimeZoneKey(String zoneId) {
        Objects.requireNonNull(zoneId, "Zone id is null");
        TimeZoneKey.checkArgument(!zoneId.isEmpty(), "Zone id is an empty string", new Object[0]);
        TimeZoneKey zoneKey = ZONE_ID_TO_KEY.get(zoneId.toLowerCase(Locale.ENGLISH));
        if (zoneKey == null) {
            zoneKey = ZONE_ID_TO_KEY.get(TimeZoneKey.normalizeZoneId(zoneId));
        }
        if (zoneKey == null) {
            throw new TimeZoneNotSupportedException(zoneId);
        }
        return zoneKey;
    }

    public static TimeZoneKey getTimeZoneKeyForOffset(long offsetMinutes) {
        if (offsetMinutes == 0L) {
            return UTC_KEY;
        }
        if (offsetMinutes < -840L || offsetMinutes > 840L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid offset minutes %s", offsetMinutes));
        }
        TimeZoneKey timeZoneKey = OFFSET_TIME_ZONE_KEYS[(int)offsetMinutes - -840];
        if (timeZoneKey == null) {
            throw new TimeZoneNotSupportedException(TimeZoneKey.zoneIdForOffset(offsetMinutes));
        }
        return timeZoneKey;
    }

    TimeZoneKey(String id, short key) {
        this.id = Objects.requireNonNull(id, "id is null");
        if (key < 0) {
            throw new IllegalArgumentException("key is negative");
        }
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    @JsonValue
    public short getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeZoneKey other = (TimeZoneKey)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.key, other.key);
    }

    public String toString() {
        return this.id;
    }

    public static boolean isUtcZoneId(String zoneId) {
        return TimeZoneKey.normalizeZoneId(zoneId).equals("utc");
    }

    private static String normalizeZoneId(String originalZoneId) {
        char hourOnes;
        char hourTens;
        String zoneId = originalZoneId.toLowerCase(Locale.ENGLISH);
        boolean startsWithEtc = zoneId.startsWith("etc/");
        if (startsWithEtc) {
            zoneId = zoneId.substring(4);
        }
        if (TimeZoneKey.isUtcEquivalentName(zoneId)) {
            return "utc";
        }
        int length = zoneId.length();
        boolean startsWithEtcGmt = false;
        if (length > 3 && (zoneId.startsWith("utc") || zoneId.startsWith("gmt"))) {
            if (startsWithEtc && zoneId.startsWith("gmt")) {
                startsWithEtcGmt = true;
            }
            zoneId = zoneId.substring(3);
            length = zoneId.length();
        } else if (length > 2 && zoneId.startsWith("ut")) {
            zoneId = zoneId.substring(2);
            length = zoneId.length();
        }
        if ("+00:00".equals(zoneId) || "-00:00".equals(zoneId)) {
            return "utc";
        }
        if (length == 6 && zoneId.charAt(3) == ':') {
            return zoneId;
        }
        if (length != 2 && length != 3) {
            return originalZoneId;
        }
        char signChar = zoneId.charAt(0);
        if (signChar != '+' && signChar != '-') {
            return originalZoneId;
        }
        if (startsWithEtcGmt) {
            char c = signChar = signChar == '-' ? (char)'+' : '-';
        }
        if (length == 2) {
            hourTens = '0';
            hourOnes = zoneId.charAt(1);
        } else {
            hourTens = zoneId.charAt(1);
            hourOnes = zoneId.charAt(2);
        }
        if (!Character.isDigit(hourTens) || !Character.isDigit(hourOnes)) {
            return originalZoneId;
        }
        if (hourTens == '0' && hourOnes == '0') {
            return "utc";
        }
        return "" + signChar + hourTens + hourOnes + ":00";
    }

    private static boolean isUtcEquivalentName(String zoneId) {
        return zoneId.equals("utc") || zoneId.equals("z") || zoneId.equals("ut") || zoneId.equals("uct") || zoneId.equals("ut") || zoneId.equals("gmt") || zoneId.equals("gmt0") || zoneId.equals("greenwich") || zoneId.equals("universal") || zoneId.equals("zulu");
    }

    private static String zoneIdForOffset(long offset) {
        return String.format("%s%02d:%02d", offset < 0L ? "-" : "+", Math.abs(offset / 60L), Math.abs(offset % 60L));
    }

    private static void checkArgument(boolean check, String message, Object ... args) {
        if (!check) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    static {
        OFFSET_TIME_ZONE_KEYS = new TimeZoneKey[1681];
        try (InputStream in = TimeZoneKey.class.getResourceAsStream("zone-index.properties");){
            Properties data = new Properties(){

                @Override
                public synchronized Object put(Object key, Object value) {
                    Object existingEntry = super.put(key, value);
                    if (existingEntry != null) {
                        throw new AssertionError((Object)("Zone file has duplicate entries for " + key));
                    }
                    return null;
                }
            };
            data.load(in);
            if (data.containsKey("0")) {
                throw new AssertionError((Object)"Zone file should not contain a mapping for key 0");
            }
            TreeMap<String, TimeZoneKey> zoneIdToKey = new TreeMap<String, TimeZoneKey>();
            zoneIdToKey.put(UTC_KEY.getId().toLowerCase(Locale.ENGLISH), UTC_KEY);
            short maxZoneKey = 0;
            for (Map.Entry<Object, Object> entry : data.entrySet()) {
                short zoneKey = Short.valueOf(((String)entry.getKey()).trim());
                String zoneId = ((String)entry.getValue()).trim();
                maxZoneKey = (short)Math.max(maxZoneKey, zoneKey);
                zoneIdToKey.put(zoneId.toLowerCase(Locale.ENGLISH), new TimeZoneKey(zoneId, zoneKey));
            }
            MAX_TIME_ZONE_KEY = maxZoneKey;
            ZONE_ID_TO_KEY = Collections.unmodifiableMap(new LinkedHashMap(zoneIdToKey));
            ZONE_KEYS = Collections.unmodifiableSet(new LinkedHashSet(zoneIdToKey.values()));
            TIME_ZONE_KEYS = new TimeZoneKey[maxZoneKey + 1];
            Iterator<Map.Entry<Object, Object>> iterator = zoneIdToKey.values().iterator();
            while (iterator.hasNext()) {
                TimeZoneKey timeZoneKey;
                TimeZoneKey.TIME_ZONE_KEYS[timeZoneKey.getKey()] = timeZoneKey = (TimeZoneKey)((Object)iterator.next());
            }
            for (int offset = -840; offset <= 840; offset = (int)((short)(offset + 1))) {
                TimeZoneKey zoneKey;
                if (offset == 0) continue;
                String zoneId = TimeZoneKey.zoneIdForOffset(offset);
                TimeZoneKey.OFFSET_TIME_ZONE_KEYS[offset - -840] = zoneKey = ZONE_ID_TO_KEY.get(zoneId);
            }
        }
        catch (IOException e) {
            throw new AssertionError("Error loading time zone index file", e);
        }
    }
}

