/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class Estimate {
    private static final Estimate UNKNOWN = new Estimate(Double.NaN);
    private static final Estimate ZERO = new Estimate(0.0);
    private final double value;

    public static Estimate unknown() {
        return UNKNOWN;
    }

    public static Estimate zero() {
        return ZERO;
    }

    public static Estimate of(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("value is NaN");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("value is infinite");
        }
        return new Estimate(value);
    }

    private Estimate(double value) {
        this.value = value;
    }

    public boolean isUnknown() {
        return Double.isNaN(this.value);
    }

    @JsonProperty
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Estimate estimate = (Estimate)o;
        return Double.compare(estimate.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

