/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.eventlistener;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class QueryStatistics {
    private final Duration cpuTime;
    private final Duration retriedCpuTime;
    private final Duration wallTime;
    private final Duration queuedTime;
    private final Optional<Duration> analysisTime;
    private final int peakRunningTasks;
    private final long peakUserMemoryBytes;
    private final long peakTotalNonRevocableMemoryBytes;
    private final long peakTaskUserMemory;
    private final long peakTaskTotalMemory;
    private final long peakNodeTotalMemory;
    private final long totalBytes;
    private final long totalRows;
    private final long outputBytes;
    private final long outputRows;
    private final long writtenOutputBytes;
    private final long writtenOutputRows;
    private final long writtenIntermediateBytes;
    private final long spilledBytes;
    private final double cumulativeMemory;
    private final int completedSplits;
    private final boolean complete;

    public QueryStatistics(Duration cpuTime, Duration retriedCpuTime, Duration wallTime, Duration queuedTime, Optional<Duration> analysisTime, int peakRunningTasks, long peakUserMemoryBytes, long peakTotalNonRevocableMemoryBytes, long peakTaskUserMemory, long peakTaskTotalMemory, long peakNodeTotalMemory, long totalBytes, long totalRows, long outputBytes, long outputRows, long writtenOutputBytes, long writtenOutputRows, long writtenIntermediateBytes, long spilledBytes, double cumulativeMemory, int completedSplits, boolean complete) {
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.retriedCpuTime = Objects.requireNonNull(retriedCpuTime, "retriedCpuTime is null");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.peakRunningTasks = peakRunningTasks;
        this.peakUserMemoryBytes = peakUserMemoryBytes;
        this.peakTotalNonRevocableMemoryBytes = peakTotalNonRevocableMemoryBytes;
        this.peakTaskUserMemory = peakTaskUserMemory;
        this.peakTaskTotalMemory = peakTaskTotalMemory;
        this.peakNodeTotalMemory = peakNodeTotalMemory;
        this.totalBytes = totalBytes;
        this.totalRows = totalRows;
        this.outputBytes = outputBytes;
        this.outputRows = outputRows;
        this.writtenOutputBytes = writtenOutputBytes;
        this.writtenOutputRows = writtenOutputRows;
        this.writtenIntermediateBytes = writtenIntermediateBytes;
        this.spilledBytes = spilledBytes;
        this.cumulativeMemory = cumulativeMemory;
        this.completedSplits = completedSplits;
        this.complete = complete;
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public Duration getRetriedCpuTime() {
        return this.retriedCpuTime;
    }

    public Duration getWallTime() {
        return this.wallTime;
    }

    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    public Optional<Duration> getAnalysisTime() {
        return this.analysisTime;
    }

    public int getPeakRunningTasks() {
        return this.peakRunningTasks;
    }

    public long getPeakUserMemoryBytes() {
        return this.peakUserMemoryBytes;
    }

    public long getPeakTotalNonRevocableMemoryBytes() {
        return this.peakTotalNonRevocableMemoryBytes;
    }

    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory;
    }

    public long getPeakNodeTotalMemory() {
        return this.peakNodeTotalMemory;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    public long getOutputRows() {
        return this.outputRows;
    }

    public long getWrittenOutputBytes() {
        return this.writtenOutputBytes;
    }

    public long getWrittenOutputRows() {
        return this.writtenOutputRows;
    }

    public long getWrittenIntermediateBytes() {
        return this.writtenIntermediateBytes;
    }

    public long getSpilledBytes() {
        return this.spilledBytes;
    }

    public double getCumulativeMemory() {
        return this.cumulativeMemory;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

