/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Optional;
import java.util.function.BiConsumer;

public class Int128ArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int128ArrayBlock.class).instanceSize();
    public static final int INT128_BYTES = 16;
    private final int positionOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final long[] values;
    private final long sizeInBytes;
    private final long retainedSizeInBytes;

    public Int128ArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, long[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    Int128ArrayBlock(int positionOffset, int positionCount, boolean[] valueIsNull, long[] values) {
        if (positionOffset < 0) {
            throw new IllegalArgumentException("positionOffset is negative");
        }
        this.positionOffset = positionOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - positionOffset * 2 < positionCount * 2) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - positionOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = 17L * (long)positionCount;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(valueIsNull) + SizeOf.sizeOf(values);
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 17L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        return 17L * (long)BlockUtil.countUsedPositions(positions);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 16L;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf(this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0 && offset != 8) {
            throw new IllegalArgumentException("offset must be 0 or 8");
        }
        return this.getLongUnchecked(position + this.positionOffset, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, offset, length / 8 / 2);
        return this.getSliceUnchecked(position + this.positionOffset, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        return 16;
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        int num128Integers = BlockUtil.getNum128Integers(length);
        return Slices.wrappedLongArray(this.values, (internalPosition + offset) * 2, num128Integers * 2);
    }

    @Override
    public int getSliceLengthUnchecked(int position) {
        return 16;
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        int num128Integers = BlockUtil.getNum128Integers(length);
        BlockUtil.checkValidRegion(this.positionCount, position + offset, num128Integers);
        if (otherOffset < 0 || length < 0 || otherOffset + length > otherSlice.length()) {
            throw new IllegalArgumentException(String.format("otherOffset %d, length %d are invalid for otherSlice with length %d", otherOffset, length, otherSlice.length()));
        }
        int currentPosition = (position + offset + this.positionOffset) * 2;
        for (int i = 0; i < num128Integers; ++i) {
            if (this.values[currentPosition] != otherSlice.getLong(otherOffset) || this.values[currentPosition + 1] != otherSlice.getLong(otherOffset + 8)) {
                return false;
            }
            currentPosition += 2;
            otherOffset += 16;
        }
        return true;
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull != null && this.isNullUnchecked(position + this.positionOffset);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeLong(this.values[(position + this.positionOffset) * 2]);
        blockBuilder.writeLong(this.values[(position + this.positionOffset) * 2 + 1]);
        blockBuilder.closeEntry();
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            output.writeLong(this.values[(position + this.positionOffset) * 2]);
            output.writeLong(this.values[(position + this.positionOffset) * 2 + 1]);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new Int128ArrayBlock(0, 1, blArray, new long[]{this.values[(position + this.positionOffset) * 2], this.values[(position + this.positionOffset) * 2 + 1]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        long[] newValues = new long[length * 2];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.checkReadablePosition(position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.positionOffset];
            }
            newValues[i * 2] = this.values[(position + this.positionOffset) * 2];
            newValues[i * 2 + 1] = this.values[(position + this.positionOffset) * 2 + 1];
        }
        return new Int128ArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new Int128ArrayBlock(positionOffset + this.positionOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.positionOffset, length);
        long[] newValues = BlockUtil.compactArray(this.values, positionOffset * 2, length * 2);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new Int128ArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "INT128_ARRAY";
    }

    public String toString() {
        return String.format("Int128ArrayBlock(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        assert (offset == 0 || offset == 8) : "offset must be 0 or 8";
        return this.values[internalPosition * 2 + Integer.bitCount(offset)];
    }

    @Override
    public int getOffsetBase() {
        return this.positionOffset;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] newValueIsNull = BlockUtil.appendNullToIsNullArray(this.valueIsNull, this.positionOffset, this.positionCount);
        long[] newValues = BlockUtil.ensureCapacity(this.values, (this.positionOffset + this.positionCount + 1) * 2);
        return new Int128ArrayBlock(this.positionOffset, this.positionCount + 1, newValueIsNull, newValues);
    }
}

