/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractVariableWidthType;
import com.facebook.presto.jdbc.internal.common.type.SqlVarbinary;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;

public class HyperLogLogType
extends AbstractVariableWidthType {
    public static final HyperLogLogType HYPER_LOG_LOG = new HyperLogLogType();

    @JsonCreator
    public HyperLogLogType() {
        super(TypeSignature.parseTypeSignature("HyperLogLog"), Slice.class);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlVarbinary(block.getSlice(position, 0, block.getSliceLength(position)).getBytes());
    }
}

