/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.function.OperatorType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.function.FunctionImplementationType;
import com.facebook.presto.jdbc.internal.spi.function.FunctionKind;
import com.facebook.presto.jdbc.internal.spi.function.RoutineCharacteristics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionMetadata {
    private final QualifiedObjectName name;
    private final Optional<OperatorType> operatorType;
    private final List<TypeSignature> argumentTypes;
    private final Optional<List<String>> argumentNames;
    private final TypeSignature returnType;
    private final FunctionKind functionKind;
    private final Optional<RoutineCharacteristics.Language> language;
    private final FunctionImplementationType implementationType;
    private final boolean deterministic;
    private final boolean calledOnNullInput;

    public FunctionMetadata(QualifiedObjectName name, List<TypeSignature> argumentTypes, TypeSignature returnType, FunctionKind functionKind, FunctionImplementationType implementationType, boolean deterministic, boolean calledOnNullInput) {
        this(name, Optional.empty(), argumentTypes, Optional.empty(), returnType, functionKind, Optional.empty(), implementationType, deterministic, calledOnNullInput);
    }

    public FunctionMetadata(QualifiedObjectName name, List<TypeSignature> argumentTypes, List<String> argumentNames, TypeSignature returnType, FunctionKind functionKind, RoutineCharacteristics.Language language, FunctionImplementationType implementationType, boolean deterministic, boolean calledOnNullInput) {
        this(name, Optional.empty(), argumentTypes, Optional.of(argumentNames), returnType, functionKind, Optional.of(language), implementationType, deterministic, calledOnNullInput);
    }

    public FunctionMetadata(OperatorType operatorType, List<TypeSignature> argumentTypes, TypeSignature returnType, FunctionKind functionKind, FunctionImplementationType implementationType, boolean deterministic, boolean calledOnNullInput) {
        this(operatorType.getFunctionName(), Optional.of(operatorType), argumentTypes, Optional.empty(), returnType, functionKind, Optional.empty(), implementationType, deterministic, calledOnNullInput);
    }

    private FunctionMetadata(QualifiedObjectName name, Optional<OperatorType> operatorType, List<TypeSignature> argumentTypes, Optional<List<String>> argumentNames, TypeSignature returnType, FunctionKind functionKind, Optional<RoutineCharacteristics.Language> language, FunctionImplementationType implementationType, boolean deterministic, boolean calledOnNullInput) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(argumentTypes, "argumentTypes is null")));
        this.argumentNames = Objects.requireNonNull(argumentNames, "argumentNames is null").map(names -> Collections.unmodifiableList(new ArrayList(names)));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.language = Objects.requireNonNull(language, "language is null");
        this.implementationType = Objects.requireNonNull(implementationType, "implementationType is null");
        this.deterministic = deterministic;
        this.calledOnNullInput = calledOnNullInput;
    }

    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    public QualifiedObjectName getName() {
        return this.name;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Optional<List<String>> getArgumentNames() {
        return this.argumentNames;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public Optional<OperatorType> getOperatorType() {
        return this.operatorType;
    }

    public Optional<RoutineCharacteristics.Language> getLanguage() {
        return this.language;
    }

    public FunctionImplementationType getImplementationType() {
        return this.implementationType;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionMetadata other = (FunctionMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.operatorType, other.operatorType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.argumentNames, other.argumentNames) && Objects.equals(this.returnType, other.returnType) && Objects.equals((Object)this.functionKind, (Object)other.functionKind) && Objects.equals(this.language, other.language) && Objects.equals((Object)this.implementationType, (Object)other.implementationType) && Objects.equals(this.deterministic, other.deterministic) && Objects.equals(this.calledOnNullInput, other.calledOnNullInput);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.operatorType, this.argumentTypes, this.argumentNames, this.returnType, this.functionKind, this.language, this.implementationType, this.deterministic, this.calledOnNullInput});
    }
}

