/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.predicate;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.predicate.Primitives;
import com.facebook.presto.jdbc.internal.common.predicate.Utils;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;

@Deprecated
public final class NullableValue {
    private final Type type;
    private final Object value;

    public NullableValue(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        if (value != null && !Primitives.wrap(type.getJavaType()).isInstance(value)) {
            throw new IllegalArgumentException(String.format("Object '%s' does not match type %s", value, type.getJavaType()));
        }
        this.type = type;
        this.value = value;
    }

    public static NullableValue of(Type type, Object value) {
        Objects.requireNonNull(value, "value is null");
        return new NullableValue(type, value);
    }

    public static NullableValue asNull(Type type) {
        return new NullableValue(type, null);
    }

    @JsonCreator
    public static NullableValue fromSerializable(@JsonProperty(value="serializable") Serializable serializable) {
        Type type = serializable.getType();
        Block block = serializable.getBlock();
        return new NullableValue(type, block == null ? null : Utils.blockToNativeValue(type, block));
    }

    @JsonProperty
    public Serializable getSerializable() {
        return new Serializable(this.type, this.value == null ? null : Utils.nativeValueToBlock(this.type, this.value));
    }

    public Block asBlock() {
        return Utils.nativeValueToBlock(this.type, this.value);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = Objects.hash(this.type);
        if (this.value != null) {
            hash = hash * 31 + (int)this.type.hash(Utils.nativeValueToBlock(this.type, this.value), 0);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NullableValue other = (NullableValue)obj;
        return Objects.equals(this.type, other.type) && this.value == null == (other.value == null) && (this.value == null || this.type.equalTo(Utils.nativeValueToBlock(this.type, this.value), 0, Utils.nativeValueToBlock(other.type, other.value), 0));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NullableValue{");
        sb.append("type=").append(this.type);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public static class Serializable {
        private final Type type;
        private final Block block;

        @JsonCreator
        public Serializable(@JsonProperty(value="type") Type type, @JsonProperty(value="block") Block block) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.block = block;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public Block getBlock() {
            return this.block;
        }
    }
}

