/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.guava.primitives.Ints;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrestoArray
implements Array {
    private final String elementTypeName;
    private final int elementType;
    private final Object[] array;

    PrestoArray(String elementTypeName, int elementType, List<?> array) {
        this.elementTypeName = Objects.requireNonNull(elementTypeName, "elementType is null");
        this.elementType = elementType;
        this.array = Objects.requireNonNull(array, "array is null").toArray();
    }

    @Override
    public String getBaseTypeName() {
        return this.elementTypeName;
    }

    @Override
    public int getBaseType() {
        return this.elementType;
    }

    @Override
    public Object getArray() {
        return this.array.clone();
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        int arrayOffset = Ints.saturatedCast(index - 1L);
        if (index < 1L || count < 0 || arrayOffset + count > this.array.length) {
            throw new SQLException("Index out of bounds");
        }
        return Arrays.copyOfRange(this.array, arrayOffset, arrayOffset + count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet not supported");
    }

    @Override
    public void free() {
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

