/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.common.type.SqlTimestamp;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;

public final class TimestampType
extends AbstractLongType {
    public static final TimestampType TIMESTAMP = new TimestampType();

    private TimestampType() {
        super(TypeSignature.parseTypeSignature("timestamp"));
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (properties.isLegacyTimestamp()) {
            return new SqlTimestamp(block.getLong(position), properties.getTimeZoneKey());
        }
        return new SqlTimestamp(block.getLong(position));
    }

    @Override
    public boolean equals(Object other) {
        return other == TIMESTAMP;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

