/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.Page;
import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionResult;
import com.facebook.presto.jdbc.internal.common.type.TypeManager;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.UserDefinedType;
import com.facebook.presto.jdbc.internal.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandle;
import com.facebook.presto.jdbc.internal.spi.function.FunctionMetadata;
import com.facebook.presto.jdbc.internal.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.jdbc.internal.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.jdbc.internal.spi.function.Signature;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunction;
import com.facebook.presto.jdbc.internal.spi.function.SqlInvokedFunction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface FunctionNamespaceManager<F extends SqlFunction> {
    public void setBlockEncodingSerde(BlockEncodingSerde var1);

    public FunctionNamespaceTransactionHandle beginTransaction();

    public void commit(FunctionNamespaceTransactionHandle var1);

    public void abort(FunctionNamespaceTransactionHandle var1);

    public void createFunction(SqlInvokedFunction var1, boolean var2);

    public void alterFunction(QualifiedObjectName var1, Optional<List<TypeSignature>> var2, AlterRoutineCharacteristics var3);

    public void dropFunction(QualifiedObjectName var1, Optional<List<TypeSignature>> var2, boolean var3);

    public Collection<F> listFunctions(Optional<String> var1, Optional<String> var2);

    default public boolean canResolveFunction() {
        return false;
    }

    default public FunctionHandle resolveFunction(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedObjectName functionName, List<TypeSignature> parameterTypes) {
        throw new UnsupportedOperationException("Does not support resolving function");
    }

    public Collection<F> getFunctions(Optional<? extends FunctionNamespaceTransactionHandle> var1, QualifiedObjectName var2);

    public FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> var1, Signature var2);

    public FunctionMetadata getFunctionMetadata(FunctionHandle var1);

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle var1);

    public CompletableFuture<SqlFunctionResult> executeFunction(String var1, FunctionHandle var2, Page var3, List<Integer> var4, TypeManager var5);

    public void addUserDefinedType(UserDefinedType var1);

    public Optional<UserDefinedType> getUserDefinedType(QualifiedObjectName var1);
}

