/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.relation;

import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpressionVisitor;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class InputReferenceExpression
extends RowExpression {
    private final int field;
    private final Type type;

    @JsonCreator
    public InputReferenceExpression(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="field") int field, @JsonProperty(value="type") Type type) {
        super(sourceLocation);
        Objects.requireNonNull(type, "type is null");
        this.field = field;
        this.type = type;
    }

    @JsonProperty
    public int getField() {
        return this.field;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.type);
    }

    @Override
    public String toString() {
        return "#" + this.field;
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInputReference(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InputReferenceExpression other = (InputReferenceExpression)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.type, other.type);
    }
}

