/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.array;

import com.facebook.presto.jdbc.internal.common.array.BigArrays;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Arrays;

public final class DoubleBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfDoubleArray(1024);
    private final double initialValue;
    private double[][] array;
    private long capacity;
    private int segments;

    public DoubleBigArray() {
        this(0.0);
    }

    public DoubleBigArray(double initialValue) {
        this.initialValue = initialValue;
        this.array = new double[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public double get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, double value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void add(long index, double value) {
        double[] dArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        dArray[n] = dArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (double[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        double[] newSegment = new double[1024];
        if (this.initialValue != 0.0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

