/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.common.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class RunLengthEncodedBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RunLengthEncodedBlock.class).instanceSize();
    private final Block value;
    private final int positionCount;

    public static Block create(Type type, Object value, int positionCount) {
        Block block = Utils.nativeValueToBlock(type, value);
        if (block instanceof RunLengthEncodedBlock) {
            block = ((RunLengthEncodedBlock)block).getValue();
        }
        return new RunLengthEncodedBlock(block, positionCount);
    }

    public RunLengthEncodedBlock(Block value, int positionCount) {
        Objects.requireNonNull(value, "value is null");
        if (value.getPositionCount() != 1) {
            throw new IllegalArgumentException(String.format("Expected value to contain a single position but has %s positions", value.getPositionCount()));
        }
        this.value = value instanceof RunLengthEncodedBlock ? ((RunLengthEncodedBlock)value).getValue() : value;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
    }

    public Block getValue() {
        return this.value;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.value.getSizeInBytes();
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getLogicalSizeInBytes() {
        return (long)this.positionCount * this.value.getLogicalSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.value.getRetainedSizeInBytes();
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.value.getEstimatedDataSizeForStats(0);
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.value, this.value.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "RLE";
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            BlockUtil.checkValidPosition(positions[i], this.positionCount);
        }
        return new RunLengthEncodedBlock(this.value, length);
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            BlockUtil.checkValidPosition(positions[i], this.positionCount);
        }
        return new RunLengthEncodedBlock(this.value.copyRegion(0, 1), length);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return new RunLengthEncodedBlock(this.value, length);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return this.value.getSizeInBytes();
    }

    @Override
    public long getRegionLogicalSizeInBytes(int position, int length) {
        return (long)length * this.value.getLogicalSizeInBytes();
    }

    @Override
    public long getApproximateRegionLogicalSizeInBytes(int position, int length) {
        return (long)this.positionCount * this.value.getApproximateRegionLogicalSizeInBytes(0, 1);
    }

    @Override
    public long getPositionsSizeInBytes(@Nullable boolean[] positions, int usedPositionCount) {
        return this.value.getSizeInBytes();
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return new RunLengthEncodedBlock(this.value.copyRegion(0, 1), length);
    }

    @Override
    public int getSliceLength(int position) {
        this.checkReadablePosition(position);
        return this.value.getSliceLength(0);
    }

    @Override
    public byte getByte(int position) {
        this.checkReadablePosition(position);
        return this.value.getByte(0);
    }

    @Override
    public short getShort(int position) {
        this.checkReadablePosition(position);
        return this.value.getShort(0);
    }

    @Override
    public int getInt(int position) {
        this.checkReadablePosition(position);
        return this.value.getInt(0);
    }

    @Override
    public long getLong(int position) {
        this.checkReadablePosition(position);
        return this.value.getLong(0);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkReadablePosition(position);
        return this.value.getLong(0, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.value.getSlice(0, offset, length);
    }

    @Override
    public Block getBlock(int position) {
        this.checkReadablePosition(position);
        return this.value.getBlock(0);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.value.bytesEqual(0, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkReadablePosition(position);
        return this.value.bytesCompare(0, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        this.value.writeBytesTo(0, offset, length, blockBuilder);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, SliceOutput sliceOutput) {
        this.checkReadablePosition(position);
        this.value.writeBytesTo(0, offset, length, sliceOutput);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        this.value.writePositionTo(0, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        this.checkReadablePosition(position);
        this.value.writePositionTo(0, output);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkReadablePosition(position);
        return this.value.equals(0, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.checkReadablePosition(position);
        return this.value.hash(0, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        this.checkReadablePosition(leftPosition);
        return this.value.compareTo(0, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return this.value;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.value.isNull(0);
    }

    @Override
    public boolean mayHaveNull() {
        return this.positionCount > 0 && this.value.isNull(0);
    }

    public String toString() {
        return String.format("RunLengthEncodedBlock(%d){positionCount=%d,value=%s}", this.hashCode(), this.getPositionCount(), this.value);
    }

    @Override
    public Block getLoadedBlock() {
        Block loadedValueBlock = this.value.getLoadedBlock();
        if (loadedValueBlock == this.value) {
            return this;
        }
        return new RunLengthEncodedBlock(loadedValueBlock, this.positionCount);
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.positionCount) {
            throw new IllegalArgumentException("position is not valid: " + position);
        }
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getByte(0);
    }

    @Override
    public short getShortUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getShort(0);
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getInt(0);
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getLong(0);
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getLong(0, offset);
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getSlice(0, offset, length);
    }

    @Override
    public int getSliceLengthUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getSliceLength(0);
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.value.getBlock(0);
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, 0, this.getPositionCount()));
        return this.value.isNull(0);
    }

    @Override
    public Block appendNull() {
        if (this.value.isNull(0)) {
            return new RunLengthEncodedBlock(this.value, this.positionCount + 1);
        }
        Block dictionary = this.value.appendNull();
        int[] ids = new int[this.positionCount + 1];
        ids[this.positionCount] = 1;
        return new DictionaryBlock(dictionary, ids);
    }
}

