/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;

public abstract class AbstractSingleMapBlock
implements Block {
    abstract int getOffset();

    abstract Block getRawKeyBlock();

    abstract Block getRawValueBlock();

    private int getAbsolutePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid: " + position);
        }
        return position + this.getOffset();
    }

    @Override
    public boolean isNull(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            if (this.getRawKeyBlock().isNull(position / 2)) {
                throw new IllegalStateException("Map key is null at position: " + position);
            }
            return false;
        }
        return this.getRawValueBlock().isNull(position / 2);
    }

    @Override
    public byte getByte(int position) {
        return this.getByteUnchecked(this.getAbsolutePosition(position));
    }

    @Override
    public short getShort(int position) {
        return this.getShortUnchecked(this.getAbsolutePosition(position));
    }

    @Override
    public int getInt(int position) {
        return this.getIntUnchecked(this.getAbsolutePosition(position));
    }

    @Override
    public long getLong(int position) {
        return this.getLongUnchecked(this.getAbsolutePosition(position));
    }

    @Override
    public long getLong(int position, int offset) {
        return this.getLongUnchecked(this.getAbsolutePosition(position), offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.getSliceUnchecked(this.getAbsolutePosition(position), offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        return this.getSliceLengthUnchecked(this.getAbsolutePosition(position));
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().compareTo(position / 2, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
        }
        return this.getRawValueBlock().compareTo(position / 2, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
        }
        return this.getRawValueBlock().bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
        }
        return this.getRawValueBlock().bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getRawKeyBlock().writeBytesTo(position / 2, offset, length, blockBuilder);
        } else {
            this.getRawValueBlock().writeBytesTo(position / 2, offset, length, blockBuilder);
        }
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, SliceOutput sliceOutput) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getRawKeyBlock().writeBytesTo(position / 2, offset, length, sliceOutput);
        } else {
            this.getRawValueBlock().writeBytesTo(position / 2, offset, length, sliceOutput);
        }
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
        }
        return this.getRawValueBlock().equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().hash(position / 2, offset, length);
        }
        return this.getRawValueBlock().hash(position / 2, offset, length);
    }

    @Override
    public Block getBlock(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getBlock(position / 2);
        }
        return this.getRawValueBlock().getBlock(position / 2);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getRawKeyBlock().writePositionTo(position / 2, blockBuilder);
        } else {
            this.getRawValueBlock().writePositionTo(position / 2, blockBuilder);
        }
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getRawKeyBlock().writePositionTo(position / 2, output);
        } else {
            this.getRawValueBlock().writePositionTo(position / 2, output);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getSingleValueBlock(position / 2);
        }
        return this.getRawValueBlock().getSingleValueBlock(position / 2);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getEstimatedDataSizeForStats(position / 2);
        }
        return this.getRawValueBlock().getEstimatedDataSizeForStats(position / 2);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int usedPositionCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getByte(internalPosition / 2);
        }
        return this.getRawValueBlock().getByte(internalPosition / 2);
    }

    @Override
    public short getShortUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getShort(internalPosition / 2);
        }
        return this.getRawValueBlock().getShort(internalPosition / 2);
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getInt(internalPosition / 2);
        }
        return this.getRawValueBlock().getInt(internalPosition / 2);
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getLong(internalPosition / 2);
        }
        return this.getRawValueBlock().getLong(internalPosition / 2);
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getLong(internalPosition / 2, offset);
        }
        return this.getRawValueBlock().getLong(internalPosition / 2, offset);
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getSlice(internalPosition / 2, offset, length);
        }
        return this.getRawValueBlock().getSlice(internalPosition / 2, offset, length);
    }

    @Override
    public int getSliceLengthUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getSliceLength(internalPosition / 2);
        }
        return this.getRawValueBlock().getSliceLength(internalPosition / 2);
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return this.getRawKeyBlock().getBlock(internalPosition / 2);
        }
        return this.getRawValueBlock().getBlock(internalPosition / 2);
    }

    @Override
    public int getOffsetBase() {
        return this.getOffset();
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffset(), this.getPositionCount()));
        if (internalPosition % 2 == 0) {
            return false;
        }
        return this.getRawValueBlock().isNull(internalPosition / 2);
    }
}

