/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.spi.security.SelectedRole;
import com.facebook.presto.jdbc.internal.spi.security.TokenAuthenticator;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectorIdentity {
    private final String user;
    private final Optional<Principal> principal;
    private final Optional<SelectedRole> role;
    private final Map<String, String> extraCredentials;
    private final Map<String, TokenAuthenticator> extraAuthenticators;
    private final Optional<String> selectedUser;
    private final Optional<String> reasonForSelect;

    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> role) {
        this(user, principal, role, Collections.emptyMap(), Collections.emptyMap(), Optional.empty(), Optional.empty());
    }

    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> role, Map<String, String> extraCredentials, Map<String, TokenAuthenticator> extraAuthenticators, Optional<String> selectedUser, Optional<String> reasonForSelect) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.role = Objects.requireNonNull(role, "role is null");
        this.extraCredentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null")));
        this.extraAuthenticators = Collections.unmodifiableMap(new HashMap<String, TokenAuthenticator>(Objects.requireNonNull(extraAuthenticators, "extraAuthenticators is null")));
        this.selectedUser = Objects.requireNonNull(selectedUser, "selectedUser is null");
        this.reasonForSelect = Objects.requireNonNull(reasonForSelect, "reasonForSelect is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Optional<SelectedRole> getRole() {
        return this.role;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public Map<String, TokenAuthenticator> getExtraAuthenticators() {
        return this.extraAuthenticators;
    }

    public Optional<String> getSelectedUser() {
        return this.selectedUser;
    }

    public Optional<String> getReasonForSelect() {
        return this.reasonForSelect;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorIdentity{");
        sb.append("user='").append(this.user).append('\'');
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        this.role.ifPresent(role -> sb.append(", role=").append(role));
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append(", extraAuthenticators=").append(this.extraAuthenticators.keySet());
        this.selectedUser.ifPresent(user -> sb.append(", selectedUser=").append((String)user));
        this.reasonForSelect.ifPresent(reason -> sb.append(", reasonForSelect=").append((String)reason));
        sb.append('}');
        return sb.toString();
    }
}

