/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.common.type.BigintType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.relation.CallExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VariableAllocator {
    protected static final Pattern DISALLOWED_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9_\\-$]+");
    protected final Map<String, Type> variables;
    protected int nextId;

    public VariableAllocator() {
        this.variables = new HashMap<String, Type>();
    }

    public VariableAllocator(Collection<VariableReferenceExpression> initial) {
        this.variables = Objects.requireNonNull(initial, "initial is null").stream().collect(Collectors.toMap(VariableReferenceExpression::getName, VariableReferenceExpression::getType));
    }

    protected static Integer tryParse(String str) {
        Integer result = null;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public VariableReferenceExpression newVariable(VariableReferenceExpression variableHint) {
        VariableAllocator.checkArgument(this.variables.containsKey(variableHint.getName()), "variableHint name not in variables map");
        return this.newVariable(variableHint.getSourceLocation(), variableHint.getName(), variableHint.getType());
    }

    public VariableReferenceExpression newVariable(String nameHint, Type type) {
        return this.newVariable(Optional.empty(), nameHint, type);
    }

    public VariableReferenceExpression newVariable(String nameHint, Type type, String suffix) {
        return this.newVariable(Optional.empty(), nameHint, type);
    }

    public VariableReferenceExpression newVariable(Optional<SourceLocation> sourceLocation, String nameHint, Type type) {
        return this.newVariable(sourceLocation, nameHint, type, null);
    }

    public VariableReferenceExpression newVariable(Optional<SourceLocation> sourceLocation, String nameHint, Type type, String suffix) {
        String tail;
        Objects.requireNonNull(nameHint, "name is null");
        Objects.requireNonNull(type, "type is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (VariableAllocator.tryParse(tail = nameHint.substring(index + 1)) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        String unique = nameHint;
        if (suffix != null) {
            unique = unique + "$" + suffix;
        }
        String attempt = unique = DISALLOWED_CHAR_PATTERN.matcher(unique).replaceAll("_");
        while (this.variables.putIfAbsent(attempt, type) != null) {
            attempt = unique + "_" + this.nextId();
        }
        return new VariableReferenceExpression(sourceLocation, attempt, type);
    }

    public VariableReferenceExpression newVariable(RowExpression expression) {
        return this.newVariable(expression, null);
    }

    public VariableReferenceExpression newVariable(RowExpression expression, String suffix) {
        String nameHint = "expr";
        if (expression instanceof VariableReferenceExpression) {
            nameHint = ((VariableReferenceExpression)expression).getName();
        } else if (expression instanceof CallExpression) {
            nameHint = ((CallExpression)expression).getDisplayName();
        }
        return this.newVariable(expression.getSourceLocation(), nameHint, expression.getType(), suffix);
    }

    public VariableReferenceExpression getVariableReferenceExpression(Optional<SourceLocation> sourceLocation, String name) {
        VariableAllocator.checkArgument(this.variables.containsKey(name), "variable map does not contain name " + name);
        return new VariableReferenceExpression(sourceLocation, name, this.variables.get(name));
    }

    public VariableReferenceExpression newHashVariable() {
        return this.newVariable("$hashValue", BigintType.BIGINT);
    }

    protected int nextId() {
        return this.nextId++;
    }

    public Map<String, Type> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }
}

