/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.constraints;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonSubTypes;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonTypeInfo;
import com.facebook.presto.jdbc.internal.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.jdbc.internal.spi.constraints.UniqueConstraint;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PrimaryKeyConstraint.class, name="primarykeyconstraint"), @JsonSubTypes.Type(value=UniqueConstraint.class, name="uniqueconstraint")})
public abstract class TableConstraint<T> {
    private final Optional<String> name;
    private final boolean enforced;
    private final boolean rely;
    private final Set<T> columns;

    protected TableConstraint(Optional<String> name, Set<T> columnNames, boolean enforced, boolean rely) {
        this.enforced = Objects.requireNonNull(Boolean.valueOf(enforced), "enabled is null");
        this.rely = Objects.requireNonNull(Boolean.valueOf(rely), "rely is null");
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        if (columnNames.isEmpty()) {
            throw new IllegalArgumentException("columnNames is empty.");
        }
        this.columns = Collections.unmodifiableSet(new HashSet<T>(columnNames));
    }

    public abstract <T, R> Optional<TableConstraint<R>> rebaseConstraint(Map<T, R> var1);

    @JsonProperty
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isEnforced() {
        return this.enforced;
    }

    @JsonProperty
    public boolean isRely() {
        return this.rely;
    }

    @JsonProperty
    public Set<T> getColumns() {
        return this.columns;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getColumns(), this.isEnforced(), this.isRely());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableConstraint constraint = (TableConstraint)obj;
        return Objects.equals(this.getName(), constraint.getName()) && Objects.equals(this.getColumns(), constraint.getColumns()) && Objects.equals(this.isEnforced(), constraint.isEnforced()) && Objects.equals(this.isRely(), constraint.isRely());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("name='").append(this.name.orElse("null")).append('\'');
        stringBuilder.append(", columns='").append(this.columns).append('\'');
        stringBuilder.append(", enforced='").append(this.enforced).append('\'');
        stringBuilder.append(", rely='").append(this.rely).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

