/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jol.info;

import com.facebook.presto.jdbc.internal.jol.util.VMSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldData {
    private final String name;
    private final String type;
    private final String klass;
    private final Field refField;
    private final int vmOffset;

    public static FieldData create(String hostKlass, String fieldName, String fieldType) {
        return new FieldData(null, -1, hostKlass, fieldName, fieldType);
    }

    public static FieldData parse(Field field) {
        return new FieldData(field, FieldData.computeOffset(field), field.getDeclaringClass().getSimpleName(), field.getName(), field.getType().getSimpleName());
    }

    private FieldData(Field refField, int vmOffset, String hostKlass, String fieldName, String fieldType) {
        this.klass = hostKlass;
        this.name = fieldName;
        this.type = fieldType;
        this.refField = refField;
        this.vmOffset = vmOffset;
    }

    private static int computeOffset(Field field) {
        field.setAccessible(true);
        if (Modifier.isStatic(field.getModifiers())) {
            return (int)VMSupport.U.staticFieldOffset(field);
        }
        return (int)VMSupport.U.objectFieldOffset(field);
    }

    public String typeClass() {
        return this.type;
    }

    public String hostClass() {
        return this.klass;
    }

    public String name() {
        return this.name;
    }

    public String safeValue(Object object) {
        if (this.refField != null) {
            try {
                return VMSupport.safeToString(this.refField.get(object));
            }
            catch (IllegalAccessException iae) {
                return "(access denied)";
            }
        }
        return "N/A";
    }

    public int vmOffset() {
        if (this.vmOffset != -1) {
            return this.vmOffset;
        }
        throw new IllegalStateException("VM offset is not defined");
    }
}

