/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.action.licenseinfo.LicenseInfoAction;
import com.floragunn.searchguard.action.licenseinfo.TransportLicenseInfoAction;
import com.floragunn.searchguard.action.whoami.TransportWhoAmIAction;
import com.floragunn.searchguard.action.whoami.WhoAmIAction;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auditlog.AuditLogSslExceptionHandler;
import com.floragunn.searchguard.auditlog.NullAuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.compliance.ComplianceConfig;
import com.floragunn.searchguard.compliance.ComplianceIndexingOperationListener;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.configuration.CompatConfig;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.configuration.SearchGuardIndexSearcherWrapper;
import com.floragunn.searchguard.filter.SearchGuardFilter;
import com.floragunn.searchguard.filter.SearchGuardRestFilter;
import com.floragunn.searchguard.http.SearchGuardHttpServerTransport;
import com.floragunn.searchguard.http.SearchGuardNonSslHttpServerTransport;
import com.floragunn.searchguard.http.XFFResolver;
import com.floragunn.searchguard.privileges.PrivilegesEvaluator;
import com.floragunn.searchguard.privileges.PrivilegesInterceptor;
import com.floragunn.searchguard.resolver.IndexResolverReplacer;
import com.floragunn.searchguard.rest.KibanaInfoAction;
import com.floragunn.searchguard.rest.SearchGuardHealthAction;
import com.floragunn.searchguard.rest.SearchGuardInfoAction;
import com.floragunn.searchguard.rest.SearchGuardLicenseAction;
import com.floragunn.searchguard.rest.TenantInfoAction;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLNettyTransport;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.ModuleInfo;
import com.floragunn.searchguard.support.ReflectionHelper;
import com.floragunn.searchguard.support.SgUtils;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.transport.DefaultInterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.SearchGuardInterceptor;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.ResourceWatcherService;

public final class SearchGuardPlugin
extends SearchGuardSSLPlugin
implements ClusterPlugin,
MapperPlugin {
    private static final String KEYWORD = ".keyword";
    private final boolean dlsFlsAvailable;
    private final Constructor<?> dlsFlsConstructor;
    private volatile SearchGuardRestFilter sgRestHandler;
    private volatile SearchGuardInterceptor sgi;
    private volatile PrivilegesEvaluator evaluator;
    private volatile ThreadPool threadPool;
    private volatile ConfigurationRepository cr;
    private volatile AdminDNs adminDns;
    private volatile ClusterService cs;
    private volatile AuditLog auditLog;
    private volatile BackendRegistry backendRegistry;
    private volatile SslExceptionHandler sslExceptionHandler;
    private volatile Client localClient;
    private final boolean disabled;
    private final boolean enterpriseModulesEnabled;
    private final boolean sslOnly;
    private final List<String> demoCertHashes = new ArrayList<String>(3);
    private volatile SearchGuardFilter sgf;
    private volatile ComplianceConfig complianceConfig;
    private volatile IndexResolverReplacer irr;
    private volatile NamedXContentRegistry namedXContentRegistry = null;
    private volatile DlsFlsRequestValve dlsFlsValve = null;

    public void close() throws IOException {
        super.close();
    }

    private final SslExceptionHandler evaluateSslExceptionHandler() {
        if (this.client || this.disabled || this.sslOnly) {
            return new SslExceptionHandler(){};
        }
        return Objects.requireNonNull(this.sslExceptionHandler);
    }

    private static boolean isDisabled(Settings settings) {
        return settings.getAsBoolean("searchguard.disabled", Boolean.valueOf(false));
    }

    private static boolean isSslOnlyMode(Settings settings) {
        return settings.getAsBoolean("searchguard.ssl_only", Boolean.valueOf(false));
    }

    public SearchGuardPlugin(final Settings settings, final Path configPath) {
        super(settings, configPath, SearchGuardPlugin.isDisabled(settings));
        List<Path> filesWithWrongPermissions;
        this.disabled = SearchGuardPlugin.isDisabled(settings);
        if (this.disabled) {
            this.dlsFlsAvailable = false;
            this.dlsFlsConstructor = null;
            this.enterpriseModulesEnabled = false;
            this.sslOnly = false;
            this.complianceConfig = null;
            this.log.warn("Search Guard plugin installed but disabled. This can expose your configuration (including passwords) to the public.");
            return;
        }
        this.sslOnly = SearchGuardPlugin.isSslOnlyMode(settings);
        if (this.sslOnly) {
            this.dlsFlsAvailable = false;
            this.dlsFlsConstructor = null;
            this.enterpriseModulesEnabled = false;
            this.complianceConfig = null;
            this.log.warn("Search Guard plugin run in ssl only mode. No authentication or authorization is performed");
            return;
        }
        this.demoCertHashes.add("54a92508de7a39d06242a0ffbf59414d7eb478633c719e6af03938daf6de8a1a");
        this.demoCertHashes.add("742e4659c79d7cad89ea86aab70aea490f23bbfc7e72abd5f0a5d3fb4c84d212");
        this.demoCertHashes.add("db1264612891406639ecd25c894f256b7c5a6b7e1d9054cbe37b77acd2ddd913");
        this.demoCertHashes.add("2a5398e20fcb851ec30aa141f37233ee91a802683415be2945c3c312c65c97cf");
        this.demoCertHashes.add("33129547ce617f784c04e965104b2c671cce9e794d1c64c7efe58c77026246ae");
        this.demoCertHashes.add("c4af0297cc75546e1905bdfe3934a950161eee11173d979ce929f086fdf9794d");
        this.demoCertHashes.add("7a355f42c90e7543a267fbe3976c02f619036f5a34ce712995a22b342d83c3ce");
        this.demoCertHashes.add("a9b5eca1399ec8518081c0d4a21a34eec4589087ce64c04fb01a488f9ad8edc9");
        this.demoCertHashes.add("d14aefe70a592d7a29e14f3ff89c3d0070c99e87d21776aa07d333ee877e758f");
        this.demoCertHashes.add("54a70016e0837a2b0c5658d1032d7ca32e432c62c55f01a2bf5adcb69a0a7ba9");
        this.demoCertHashes.add("bdc141ab2272c779d0f242b79063152c49e1b06a2af05e0fd90d505f2b44d5f5");
        this.demoCertHashes.add("3e839e2b059036a99ee4f742814995f2fb0ced7e9d68a47851f43a3c630b5324");
        this.demoCertHashes.add("9b13661c073d864c28ad7b13eda67dcb6cbc2f04d116adc7c817c20b4c7ed361");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (Security.getProvider("BC") == null) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                }
                return null;
            }
        });
        this.enterpriseModulesEnabled = settings.getAsBoolean("searchguard.enterprise_modules_enabled", Boolean.valueOf(true));
        ReflectionHelper.init(this.enterpriseModulesEnabled);
        ReflectionHelper.registerMngtRestApiHandler(settings);
        this.log.info("Clustername: {}", (Object)settings.get("cluster.name", "elasticsearch"));
        if (!this.transportSSLEnabled && !this.sslOnly) {
            throw new IllegalStateException("searchguard.ssl.transport.enabled must be set to 'true'");
        }
        if (!this.client) {
            this.dlsFlsConstructor = ReflectionHelper.instantiateDlsFlsConstructor();
            this.dlsFlsAvailable = this.dlsFlsConstructor != null;
        } else {
            this.dlsFlsAvailable = false;
            this.dlsFlsConstructor = null;
        }
        if (!this.client && (filesWithWrongPermissions = AccessController.doPrivileged(new PrivilegedAction<List<Path>>(){

            @Override
            public List<Path> run() {
                Path confPath = new Environment(settings, configPath).configFile().toAbsolutePath();
                if (Files.isDirectory(confPath, LinkOption.NOFOLLOW_LINKS)) {
                    List<Path> list;
                    block9: {
                        Stream<Path> s = Files.walk(confPath, new FileVisitOption[0]);
                        try {
                            list = s.distinct().filter(p -> SearchGuardPlugin.this.checkFilePermissions(p)).collect(Collectors.toList());
                            if (s == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (s != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                SearchGuardPlugin.this.log.error((Object)e);
                                return null;
                            }
                        }
                        s.close();
                    }
                    return list;
                }
                return Collections.emptyList();
            }
        })) != null && filesWithWrongPermissions.size() > 0) {
            for (Path p : filesWithWrongPermissions) {
                if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)) {
                    this.log.warn("Directory " + p + " has insecure file permissions (should be 0700)");
                    continue;
                }
                this.log.warn("File " + p + " has insecure file permissions (should be 0600)");
            }
        }
        if (!this.client && !settings.getAsBoolean("searchguard.allow_unsafe_democertificates", Boolean.valueOf(false)).booleanValue()) {
            List<String> files = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                @Override
                public List<String> run() {
                    Path confPath = new Environment(settings, configPath).configFile().toAbsolutePath();
                    if (Files.isDirectory(confPath, LinkOption.NOFOLLOW_LINKS)) {
                        List<String> list;
                        block9: {
                            Stream<Path> s = Files.walk(confPath, new FileVisitOption[0]);
                            try {
                                list = s.distinct().map(p -> SearchGuardPlugin.this.sha256(p)).collect(Collectors.toList());
                                if (s == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (s != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    SearchGuardPlugin.this.log.error((Object)e);
                                    return null;
                                }
                            }
                            s.close();
                        }
                        return list;
                    }
                    return Collections.emptyList();
                }
            });
            if (files != null) {
                this.demoCertHashes.retainAll(files);
                if (!this.demoCertHashes.isEmpty()) {
                    this.log.error("Demo certificates found but searchguard.allow_unsafe_democertificates is set to false.See http://docs.search-guard.com/latest/demo-installer-generated-artefacts#allow-demo-certificates-and-auto-initialization");
                    throw new RuntimeException("Demo certificates found " + this.demoCertHashes);
                }
            } else {
                throw new RuntimeException("Unable to look for demo certificates");
            }
        }
    }

    private String sha256(Path p) {
        if (!Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
            return "";
        }
        if (!Files.isReadable(p)) {
            this.log.debug("Unreadable file " + p + " found");
            return "";
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA256");
            String hash = Hex.toHexString((byte[])digester.digest(Files.readAllBytes(p)));
            this.log.debug(hash + " :: " + p);
            return hash;
        }
        catch (Exception e) {
            throw new ElasticsearchSecurityException("Unable to digest file " + p, e, new Object[0]);
        }
    }

    private boolean checkFilePermissions(Path p) {
        Set<PosixFilePermission> perms;
        if (p == null) {
            return false;
        }
        try {
            perms = Files.getPosixFilePermissions(p, LinkOption.NOFOLLOW_LINKS);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot determine posix file permissions for {} due to {}", (Object)p, (Object)e);
            }
            return false;
        }
        if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS) ? perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE) : perms.contains((Object)PosixFilePermission.OWNER_EXECUTE) || perms.contains((Object)PosixFilePermission.GROUP_EXECUTE) || perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            return true;
        }
        return perms.contains((Object)PosixFilePermission.OTHERS_READ) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client && !this.disabled) {
            handlers.addAll(super.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
            if (!this.sslOnly) {
                handlers.add((RestHandler)new SearchGuardInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
                handlers.add((RestHandler)new KibanaInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
                handlers.add((RestHandler)new SearchGuardLicenseAction(settings, restController));
                handlers.add((RestHandler)new SearchGuardHealthAction(settings, restController, Objects.requireNonNull(this.backendRegistry)));
                handlers.add((RestHandler)new TenantInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool), Objects.requireNonNull(this.cs), Objects.requireNonNull(this.adminDns)));
                Collection<RestHandler> apiHandler = ReflectionHelper.instantiateMngtRestApiHandler(settings, this.configPath, restController, this.localClient, this.adminDns, this.cr, this.cs, Objects.requireNonNull(this.principalExtractor), this.evaluator, this.threadPool, Objects.requireNonNull(this.auditLog));
                handlers.addAll(apiHandler);
                this.log.debug("Added {} management rest handler(s)", (Object)apiHandler.size());
            }
        }
        return handlers;
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        if (this.client || this.disabled || this.sslOnly) {
            return rh -> rh;
        }
        return rh -> this.sgRestHandler.wrap((RestHandler)rh);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(1);
        if (!this.disabled && !this.sslOnly) {
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigUpdateAction.INSTANCE, TransportConfigUpdateAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)LicenseInfoAction.INSTANCE, TransportLicenseInfoAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)WhoAmIAction.INSTANCE, TransportWhoAmIAction.class, new Class[0]));
        }
        return actions;
    }

    private CheckedFunction<DirectoryReader, DirectoryReader, IOException> loadFlsDlsIndexSearcherWrapper(IndexService indexService, ComplianceIndexingOperationListener ciol, ComplianceConfig complianceConfig) {
        this.namedXContentRegistry = indexService.xContentRegistry();
        try {
            CheckedFunction flsdlsWrapper = (CheckedFunction)this.dlsFlsConstructor.newInstance(indexService, this.settings, Objects.requireNonNull(this.adminDns), Objects.requireNonNull(this.cs), Objects.requireNonNull(this.auditLog), Objects.requireNonNull(ciol), Objects.requireNonNull(complianceConfig));
            if (this.log.isDebugEnabled()) {
                this.log.debug("FLS/DLS enabled for index {}", (Object)indexService.index().getName());
            }
            return flsdlsWrapper;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to enable FLS/DLS", ex);
        }
    }

    public void onIndexModule(IndexModule indexModule) {
        if (!(this.disabled || this.client || this.sslOnly)) {
            this.log.debug("Handle complianceConfig=" + this.complianceConfig + "/dlsFlsAvailable: " + this.dlsFlsAvailable + "/auditLog=" + this.auditLog.getClass() + " for onIndexModule() of index " + indexModule.getIndex().getName());
            if (this.dlsFlsAvailable) {
                ComplianceIndexingOperationListener ciol;
                assert (this.complianceConfig != null) : "compliance config must not be null here";
                if (this.complianceConfig.writeHistoryEnabledForIndex(indexModule.getIndex().getName())) {
                    ciol = ReflectionHelper.instantiateComplianceListener(this.complianceConfig, Objects.requireNonNull(this.auditLog));
                    indexModule.addIndexOperationListener((IndexingOperationListener)ciol);
                } else {
                    ciol = new ComplianceIndexingOperationListener();
                }
                indexModule.setReaderWrapper(indexService -> this.loadFlsDlsIndexSearcherWrapper((IndexService)indexService, ciol, this.complianceConfig));
                indexModule.forceQueryCacheProvider((indexSettings, nodeCache) -> new QueryCache((IndexSettings)indexSettings, (IndicesQueryCache)nodeCache){
                    final /* synthetic */ IndexSettings val$indexSettings;
                    final /* synthetic */ IndicesQueryCache val$nodeCache;
                    {
                        this.val$indexSettings = indexSettings;
                        this.val$nodeCache = indicesQueryCache;
                    }

                    public Index index() {
                        return this.val$indexSettings.getIndex();
                    }

                    public void close() throws ElasticsearchException {
                        this.clear("close");
                    }

                    public void clear(String reason) {
                        this.val$nodeCache.clearIndex(this.index().getName());
                    }

                    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
                        Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(SearchGuardPlugin.this.threadPool.getThreadContext(), "_sg_fls_fields"));
                        if (SgUtils.evalMap(allowedFlsFields, this.index().getName()) != null) {
                            return weight;
                        }
                        Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(SearchGuardPlugin.this.threadPool.getThreadContext(), "_sg_masked_fields"));
                        if (SgUtils.evalMap(maskedFieldsMap, this.index().getName()) != null) {
                            return weight;
                        }
                        return this.val$nodeCache.doCache(weight, policy);
                    }
                });
            } else {
                assert (this.complianceConfig == null) : "compliance config must be null here";
                indexModule.setReaderWrapper(indexService -> new SearchGuardIndexSearcherWrapper((IndexService)indexService, this.settings, Objects.requireNonNull(this.adminDns)));
            }
            indexModule.addSearchOperationListener(new SearchOperationListener(){

                public void onNewContext(SearchContext context) {
                    if (SearchGuardPlugin.this.enterpriseModulesEnabled) {
                        SearchGuardPlugin.this.dlsFlsValve.handleSearchContext(context, SearchGuardPlugin.this.threadPool, SearchGuardPlugin.this.namedXContentRegistry);
                    }
                }

                public void onNewScrollContext(SearchContext context) {
                    ScrollContext scrollContext = context.scrollContext();
                    if (scrollContext != null) {
                        boolean interClusterRequest = HeaderHelper.isInterClusterRequest(SearchGuardPlugin.this.threadPool.getThreadContext());
                        if (AuditLog.Origin.LOCAL.toString().equals(SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(SearchGuardPlugin.this.threadPool.getThreadContext()))) {
                            scrollContext.putInContext("_sg_scroll_auth_local", (Object)Boolean.TRUE);
                        } else {
                            scrollContext.putInContext("_sg_scroll_auth", SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_user"));
                        }
                    }
                }

                public void validateSearchContext(SearchContext context, TransportRequest transportRequest) {
                    ScrollContext scrollContext = context.scrollContext();
                    if (scrollContext != null) {
                        Object _isLocal = scrollContext.getFromContext("_sg_scroll_auth_local");
                        Object _user = scrollContext.getFromContext("_sg_scroll_auth");
                        if (_user != null && _user instanceof User) {
                            User scrollUser = (User)_user;
                            User currentUser = (User)SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_user");
                            if (!scrollUser.equals(currentUser)) {
                                SearchGuardPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest, (Task)context.getTask());
                                SearchGuardPlugin.this.log.error("Wrong user {} in scroll context, expected {}", (Object)scrollUser, (Object)currentUser);
                                throw new ElasticsearchSecurityException("Wrong user in scroll context", RestStatus.FORBIDDEN, new Object[0]);
                            }
                        } else if (_isLocal != Boolean.TRUE) {
                            SearchGuardPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest, (Task)context.getTask());
                            throw new ElasticsearchSecurityException("No user in scroll context", RestStatus.FORBIDDEN, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    public List<ActionFilter> getActionFilters() {
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>(1);
        if (!(this.client || this.disabled || this.sslOnly)) {
            filters.add(Objects.requireNonNull(this.sgf));
        }
        return filters;
    }

    @Override
    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (!(this.client || this.disabled || this.sslOnly)) {
            interceptors.add(new TransportInterceptor(){

                public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(final String action, String executor, boolean forceExecution, final TransportRequestHandler<T> actualHandler) {
                    return new TransportRequestHandler<T>(){

                        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
                            SearchGuardPlugin.this.sgi.getHandler(action, actualHandler).messageReceived(request, channel, task);
                        }
                    };
                }

                public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
                    return new TransportInterceptor.AsyncSender(){

                        public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                            SearchGuardPlugin.this.sgi.sendRequestDecorate(sender, connection, action, request, options, handler);
                        }
                    };
                }
            });
        }
        return interceptors;
    }

    @Override
    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.sslOnly) {
            return super.getTransports(settings, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        }
        if (this.transportSSLEnabled) {
            transports.put("com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport", () -> new SearchGuardSSLNettyTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.sgks, this.evaluateSslExceptionHandler()));
        }
        return transports;
    }

    @Override
    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        if (this.sslOnly) {
            return super.getHttpTransports(settings, threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, xContentRegistry, networkService, dispatcher);
        }
        HashMap<String, Supplier<HttpServerTransport>> httpTransports = new HashMap<String, Supplier<HttpServerTransport>>(1);
        if (!this.disabled) {
            if (!this.client && this.httpSSLEnabled) {
                ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, this.evaluateSslExceptionHandler());
                SearchGuardHttpServerTransport sghst = new SearchGuardHttpServerTransport(settings, networkService, bigArrays, threadPool, this.sgks, this.evaluateSslExceptionHandler(), xContentRegistry, validatingDispatcher);
                httpTransports.put("com.floragunn.searchguard.http.SearchGuardHttpServerTransport", () -> sghst);
            } else if (!this.client) {
                httpTransports.put("com.floragunn.searchguard.http.SearchGuardHttpServerTransport", () -> new SearchGuardNonSslHttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher));
            }
        }
        return httpTransports;
    }

    @Override
    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (this.sslOnly) {
            return super.createComponents(localClient, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry);
        }
        this.threadPool = threadPool;
        this.cs = clusterService;
        this.localClient = localClient;
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.client || this.disabled) {
            return components;
        }
        ClusterInfoHolder cih = new ClusterInfoHolder();
        this.cs.addListener((ClusterStateListener)cih);
        this.dlsFlsValve = ReflectionHelper.instantiateDlsFlsValve();
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver();
        this.irr = new IndexResolverReplacer(resolver, clusterService, cih);
        this.auditLog = ReflectionHelper.instantiateAuditLog(this.settings, this.configPath, localClient, threadPool, resolver, clusterService);
        this.complianceConfig = this.dlsFlsAvailable && this.auditLog.getClass() != NullAuditLog.class ? new ComplianceConfig(environment, Objects.requireNonNull(this.irr), this.auditLog) : null;
        this.log.debug("Compliance config is " + this.complianceConfig + " because of dlsFlsAvailable: " + this.dlsFlsAvailable + " and auditLog=" + this.auditLog.getClass());
        this.auditLog.setComplianceConfig(this.complianceConfig);
        this.sslExceptionHandler = new AuditLogSslExceptionHandler(this.auditLog);
        String DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS = DefaultInterClusterRequestEvaluator.class.getName();
        InterClusterRequestEvaluator interClusterRequestEvaluator = new DefaultInterClusterRequestEvaluator(this.settings);
        String className = this.settings.get("searchguard.cert.intercluster_request_evaluator_class", DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS);
        this.log.debug("Using {} as intercluster request evaluator class", (Object)className);
        if (!DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS.equals(className)) {
            interClusterRequestEvaluator = ReflectionHelper.instantiateInterClusterRequestEvaluator(className, this.settings);
        }
        PrivilegesInterceptor privilegesInterceptor = ReflectionHelper.instantiatePrivilegesInterceptorImpl(resolver, clusterService, localClient, threadPool);
        this.adminDns = new AdminDNs(this.settings);
        this.cr = ConfigurationRepository.create(this.settings, this.configPath, threadPool, localClient, clusterService, this.auditLog, this.complianceConfig);
        this.cr.subscribeOnLicenseChange(this.complianceConfig);
        XFFResolver xffResolver = new XFFResolver(threadPool);
        this.backendRegistry = new BackendRegistry(this.settings, this.adminDns, xffResolver, this.auditLog, threadPool);
        CompatConfig compatConfig = new CompatConfig(environment);
        this.evaluator = new PrivilegesEvaluator(clusterService, threadPool, this.cr, resolver, this.auditLog, this.settings, privilegesInterceptor, cih, this.irr, this.enterpriseModulesEnabled);
        DynamicConfigFactory dcf = new DynamicConfigFactory(this.cr, this.settings, this.configPath, localClient, threadPool, cih);
        dcf.registerDCFListener(this.backendRegistry);
        dcf.registerDCFListener(compatConfig);
        dcf.registerDCFListener(this.irr);
        dcf.registerDCFListener(xffResolver);
        dcf.registerDCFListener(this.evaluator);
        this.cr.setDynamicConfigFactory(dcf);
        this.sgf = new SearchGuardFilter(this.evaluator, this.adminDns, this.dlsFlsValve, this.auditLog, threadPool, this.cs, this.complianceConfig, compatConfig);
        String principalExtractorClass = this.settings.get("searchguard.ssl.transport.principal_extractor_class", null);
        this.principalExtractor = principalExtractorClass == null ? new DefaultPrincipalExtractor() : ReflectionHelper.instantiatePrincipalExtractor(principalExtractorClass);
        this.sgi = new SearchGuardInterceptor(this.settings, threadPool, this.backendRegistry, this.auditLog, this.principalExtractor, interClusterRequestEvaluator, this.cs, Objects.requireNonNull(this.sslExceptionHandler), Objects.requireNonNull(cih));
        components.add(this.principalExtractor);
        components.add(this.adminDns);
        components.add(this.cr);
        components.add(xffResolver);
        components.add(this.backendRegistry);
        components.add(this.evaluator);
        components.add(this.sgi);
        components.add(dcf);
        this.sgRestHandler = new SearchGuardRestFilter(this.backendRegistry, this.auditLog, threadPool, this.principalExtractor, this.settings, this.configPath, compatConfig);
        return components;
    }

    @Override
    public Settings additionalSettings() {
        if (this.disabled) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        builder.put(super.additionalSettings());
        if (!this.sslOnly) {
            builder.put("transport.type", "com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport");
            builder.put("http.type", "com.floragunn.searchguard.http.SearchGuardHttpServerTransport");
        }
        return builder.build();
    }

    @Override
    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(super.getSettings());
        settings.add(Setting.boolSetting((String)"searchguard.ssl_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (!this.sslOnly) {
            settings.add(Setting.listSetting((String)"searchguard.authcz.admin_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.config_index_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"searchguard.authcz.impersonation_dn.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.cert.oid", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.cert.intercluster_request_evaluator_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.nodes_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.enable_snapshot_restore_privilege", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.check_snapshot_restore_write_privileges", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.disabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"searchguard.cache.ttl_minutes", (int)60, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.enterprise_modules_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.allow_unsafe_democertificates", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.allow_default_init_sgindex", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.background_init_if_sgindex_not_exist", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"searchguard.authcz.rest_impersonation_user.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.roles_mapping_resolution", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.disable_envvar_replacement", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"searchguard.audit.routes.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.groupSetting((String)"searchguard.audit.endpoints.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.intSetting((String)"searchguard.audit.threadpool.size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"searchguard.audit.threadpool.max_queue_len", (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.log_request_body", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.resolve_indices", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.enable_rest", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.enable_transport", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            ArrayList<String> disabledCategories = new ArrayList<String>(2);
            disabledCategories.add("AUTHENTICATED");
            disabledCategories.add("GRANTED_PRIVILEGES");
            settings.add(Setting.listSetting((String)"searchguard.audit.config.disabled_transport_categories", disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.disabled_rest_categories", disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            ArrayList<String> ignoredUsers = new ArrayList<String>(2);
            ignoredUsers.add("kibanaserver");
            settings.add(Setting.listSetting((String)"searchguard.audit.ignore_users", ignoredUsers, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.ignore_requests", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.resolve_bulk_requests", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.exclude_sensitive_headers", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.index", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.http_endpoints", (List)Lists.newArrayList((Object[])new String[]{"localhost:9200"}), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.enable_ssl", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.verify_hostnames", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.enable_ssl_client_auth", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemcert_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemkey_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemtrustedcas_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.cert_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.enabled_ssl_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.enabled_ssl_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.format", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.webhook.ssl.verify", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.ssl.pemtrustedcas_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.log4j.logger_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.log4j.level", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.kerberos.krb5_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.kerberos.acceptor_keytab_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.kerberos.acceptor_principal", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.restapi.roles_enabled", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.groupSetting((String)"searchguard.restapi.endpoints_disabled.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.restapi.accept_invalid_license", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.restapi.password_validation_regex", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.restapi.password_validation_error_message", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.write.watched_indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.read.watched_fields", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.write.metadata_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.read.metadata_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.write.log_diffs", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.external_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.read.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.write.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.disable_anonymous_authentication", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.immutable_indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.compliance.salt", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.internal_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.filter_sgindex_from_all_requests", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.disable_intertransport_auth_initially", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.disable_rest_auth_initially", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.restore.sgindex.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.inject_user.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.inject_user.admin.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.allow_now_in_dls", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.restapi.allow_sgconfig_modification", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.load_static_resources", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        }
        return settings;
    }

    @Override
    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        if (this.disabled) {
            return settingsFilter;
        }
        settingsFilter.add("searchguard.*");
        return settingsFilter;
    }

    public void onNodeStarted() {
        this.log.info("Node started");
        if (!(this.sslOnly || this.client || this.disabled)) {
            this.cr.initOnNodeStart();
        }
        Set<ModuleInfo> sgModules = ReflectionHelper.getModulesLoaded();
        this.log.info("{} Search Guard modules loaded so far: {}", (Object)sgModules.size(), sgModules);
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        if (this.client || this.disabled || this.sslOnly) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>(1);
        services.add(GuiceHolder.class);
        return services;
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return index -> {
            if (this.threadPool == null) {
                return field -> true;
            }
            Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(this.threadPool.getThreadContext(), "_sg_fls_fields"));
            String eval = SgUtils.evalMap(allowedFlsFields, index);
            if (eval == null) {
                return field -> true;
            }
            Set includesExcludes = (Set)allowedFlsFields.get(eval);
            HashSet<String> includesSet = new HashSet<String>(includesExcludes.size());
            HashSet<String> excludesSet = new HashSet<String>(includesExcludes.size());
            for (String incExc : includesExcludes) {
                char firstChar = incExc.charAt(0);
                if (firstChar == '!' || firstChar == '~') {
                    excludesSet.add(incExc.substring(1));
                    continue;
                }
                includesSet.add(incExc);
            }
            if (!excludesSet.isEmpty()) {
                return field -> !WildcardMatcher.matchAny((Collection<String>)excludesSet, SearchGuardPlugin.handleKeyword(field));
            }
            return field -> WildcardMatcher.matchAny((Collection<String>)includesSet, SearchGuardPlugin.handleKeyword(field));
        };
    }

    private static String handleKeyword(String field) {
        if (field != null && field.endsWith(KEYWORD)) {
            return field.substring(0, field.length() - KEYWORD.length());
        }
        return field;
    }

    public static class GuiceHolder
    implements LifecycleComponent {
        private static RepositoriesService repositoriesService;
        private static RemoteClusterService remoteClusterService;

        @Inject
        public GuiceHolder(RepositoriesService repositoriesService, TransportService remoteClusterService) {
            GuiceHolder.repositoriesService = repositoriesService;
            GuiceHolder.remoteClusterService = remoteClusterService.getRemoteClusterService();
        }

        public static RepositoriesService getRepositoriesService() {
            return repositoriesService;
        }

        public static RemoteClusterService getRemoteClusterService() {
            return remoteClusterService;
        }

        public void close() {
        }

        public Lifecycle.State lifecycleState() {
            return null;
        }

        public void addLifecycleListener(LifecycleListener listener) {
        }

        public void removeLifecycleListener(LifecycleListener listener) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

