/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.configupdate;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateNodeResponse;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SearchGuardLicense;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.impl.CType;
import com.floragunn.searchguard.support.LicenseHelper;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateNodeResponse> {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Provider<BackendRegistry> backendRegistry;
    private final ConfigurationRepository configurationRepository;
    private DynamicConfigFactory dynamicConfigFactory;

    @Inject
    public TransportConfigUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ConfigurationRepository configurationRepository, ActionFilters actionFilters, Provider<BackendRegistry> backendRegistry, DynamicConfigFactory dynamicConfigFactory) {
        super("cluster:admin/searchguard/config/update", threadPool, clusterService, transportService, actionFilters, ConfigUpdateRequest::new, NodeConfigUpdateRequest::new, "management", ConfigUpdateNodeResponse.class);
        this.configurationRepository = configurationRepository;
        this.backendRegistry = backendRegistry;
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    protected ConfigUpdateNodeResponse newNodeResponse() {
        return new ConfigUpdateNodeResponse(this.clusterService.localNode(), new String[0], null);
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, List<ConfigUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new ConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ConfigUpdateNodeResponse nodeOperation(NodeConfigUpdateRequest request) {
        this.configurationRepository.reloadConfiguration(CType.fromStringValues(request.request.getConfigTypes()));
        ((BackendRegistry)this.backendRegistry.get()).invalidateCache();
        String licenseText = this.dynamicConfigFactory.getLicenseString();
        if (licenseText != null && !licenseText.isEmpty()) {
            try {
                SearchGuardLicense license = new SearchGuardLicense(XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (String)LicenseHelper.validateLicense(licenseText), (boolean)true), this.clusterService);
                if (!license.isValid()) {
                    this.logger.warn("License " + license.getUid() + " is invalid due to " + license.getMsgs());
                }
            }
            catch (Exception e) {
                this.logger.error("Invalid license", (Throwable)e);
                return new ConfigUpdateNodeResponse(this.clusterService.localNode(), new String[0], "Invalid license: " + e);
            }
        }
        return new ConfigUpdateNodeResponse(this.clusterService.localNode(), request.request.getConfigTypes(), null);
    }

    protected NodeConfigUpdateRequest newNodeRequest(ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(request);
    }

    public static class NodeConfigUpdateRequest
    extends BaseNodeRequest {
        ConfigUpdateRequest request;

        public NodeConfigUpdateRequest() {
        }

        public NodeConfigUpdateRequest(ConfigUpdateRequest request) {
            this.request = request;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new ConfigUpdateRequest();
            this.request.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

