/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.licenseinfo;

import com.floragunn.searchguard.configuration.SearchGuardLicense;
import com.floragunn.searchguard.support.ModuleInfo;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class LicenseInfoNodeResponse
extends BaseNodeResponse {
    private SearchGuardLicense license;
    private Set<ModuleInfo> modules;

    LicenseInfoNodeResponse() {
    }

    public LicenseInfoNodeResponse(DiscoveryNode node, SearchGuardLicense license, Set<ModuleInfo> modules) {
        super(node);
        this.license = license;
        this.modules = modules;
    }

    public static LicenseInfoNodeResponse readNodeResponse(StreamInput in) throws IOException {
        LicenseInfoNodeResponse nodeResponse = new LicenseInfoNodeResponse();
        nodeResponse.readFrom(in);
        return nodeResponse;
    }

    public SearchGuardLicense getLicense() {
        return this.license;
    }

    public Set<ModuleInfo> getModules() {
        return this.modules;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.license);
        out.writeList(new LinkedList<ModuleInfo>(this.modules));
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.license = (SearchGuardLicense)in.readOptionalWriteable(SearchGuardLicense::new);
        this.modules = new HashSet<ModuleInfo>(in.readList(ModuleInfo::new));
    }

    public String toString() {
        return "LicenseInfoNodeResponse [license=" + this.license + "]";
    }
}

