/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.licenseinfo;

import com.floragunn.searchguard.action.licenseinfo.LicenseInfoNodeResponse;
import com.floragunn.searchguard.configuration.SearchGuardLicense;
import com.floragunn.searchguard.support.ModuleInfo;
import com.floragunn.searchguard.support.ModuleType;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class LicenseInfoResponse
extends BaseNodesResponse<LicenseInfoNodeResponse>
implements ToXContent {
    public LicenseInfoResponse() {
    }

    public LicenseInfoResponse(ClusterName clusterName, List<LicenseInfoNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public List<LicenseInfoNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(LicenseInfoNodeResponse::readNodeResponse);
    }

    public void writeNodesTo(StreamOutput out, List<LicenseInfoNodeResponse> nodes) throws IOException {
        out.writeStreamableList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        SearchGuardLicense license;
        List allNodes = this.getNodes();
        if (allNodes.isEmpty()) {
            throw new IOException("All nodes failed");
        }
        List nonNullLicenseNodes = allNodes.stream().filter(r -> r != null && r.getLicense() != null).collect(Collectors.toList());
        builder.startObject("sg_license");
        if (nonNullLicenseNodes.size() != allNodes.size() && nonNullLicenseNodes.size() > 0) {
            license = ((LicenseInfoNodeResponse)((Object)nonNullLicenseNodes.get(0))).getLicense();
            builder.field("uid", license.getUid());
            builder.field("type", (Object)license.getType());
            builder.field("features", (Object)license.getFeatures());
            builder.field("issue_date", license.getIssueDate());
            builder.field("expiry_date", license.getExpiryDate());
            builder.field("issued_to", license.getIssuedTo());
            builder.field("issuer", license.getIssuer());
            builder.field("start_date", license.getStartDate());
            builder.field("major_version", license.getMajorVersion());
            builder.field("cluster_name", license.getClusterName());
            builder.field("msgs", (Object)new String[]{"License mismatch across some nodes"});
            builder.field("expiry_in_days", license.getExpiresInDays());
            builder.field("is_expired", license.isExpired());
            builder.field("is_valid", false);
            builder.field("action", "Enable or disable enterprise modules on all your nodes");
            builder.field("prod_usage", "No");
            builder.field("license_required", true);
            builder.field("allowed_node_count_per_cluster", license.getAllowedNodeCount() > 1500 ? "unlimited" : String.valueOf(license.getAllowedNodeCount()));
        } else if (nonNullLicenseNodes.size() == 0) {
            builder.field("msgs", (Object)new String[]{"No license required because enterprise modules not enabled."});
            builder.field("license_required", false);
        } else {
            license = ((LicenseInfoNodeResponse)((Object)nonNullLicenseNodes.get(0))).getLicense();
            builder.field("uid", license.getUid());
            builder.field("type", (Object)license.getType());
            builder.field("features", (Object)license.getFeatures());
            builder.field("issue_date", license.getIssueDate());
            builder.field("expiry_date", license.getExpiryDate());
            builder.field("issued_to", license.getIssuedTo());
            builder.field("issuer", license.getIssuer());
            builder.field("start_date", license.getStartDate());
            builder.field("major_version", license.getMajorVersion());
            builder.field("cluster_name", license.getClusterName());
            builder.field("msgs", license.getMsgs());
            builder.field("expiry_in_days", license.getExpiresInDays());
            builder.field("is_expired", license.isExpired());
            builder.field("is_valid", license.isValid());
            builder.field("action", license.getAction());
            builder.field("prod_usage", license.getProdUsage());
            builder.field("license_required", true);
            builder.field("allowed_node_count_per_cluster", license.getAllowedNodeCount() > 1500 ? "unlimited" : String.valueOf(license.getAllowedNodeCount()));
        }
        builder.endObject();
        builder.startObject("modules");
        LinkedList<ModuleInfo> mod0 = new LinkedList<ModuleInfo>(((LicenseInfoNodeResponse)((Object)allNodes.get(0))).getModules());
        for (ModuleInfo moduleInfo : mod0) {
            ModuleType type = moduleInfo.getModuleType();
            Map<String, String> infoAsMap = moduleInfo.getAsMap();
            builder.field(type.name(), infoAsMap);
        }
        boolean mismatch = false;
        LinkedList<String> mismatchedNodes = new LinkedList<String>();
        block1: for (LicenseInfoNodeResponse node : allNodes) {
            for (ModuleInfo nodeModuleInfo : node.getModules()) {
                if (mod0.contains(nodeModuleInfo)) continue;
                mismatch = true;
                mismatchedNodes.add(node.getNode().getName());
                continue block1;
            }
        }
        builder.endObject();
        builder.startObject("compatibility");
        builder.field("modules_mismatch", mismatch);
        if (mismatch) {
            builder.field("mismatched_nodes", mismatchedNodes);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }
}

