/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.licenseinfo;

import com.floragunn.searchguard.action.licenseinfo.LicenseInfoNodeResponse;
import com.floragunn.searchguard.action.licenseinfo.LicenseInfoRequest;
import com.floragunn.searchguard.action.licenseinfo.LicenseInfoResponse;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SearchGuardLicense;
import com.floragunn.searchguard.support.ReflectionHelper;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportLicenseInfoAction
extends TransportNodesAction<LicenseInfoRequest, LicenseInfoResponse, NodeLicenseRequest, LicenseInfoNodeResponse> {
    private final ConfigurationRepository configurationRepository;

    @Inject
    public TransportLicenseInfoAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ConfigurationRepository configurationRepository, ActionFilters actionFilters) {
        super("cluster:admin/searchguard/license/info", threadPool, clusterService, transportService, actionFilters, LicenseInfoRequest::new, NodeLicenseRequest::new, "management", LicenseInfoNodeResponse.class);
        this.configurationRepository = configurationRepository;
    }

    protected LicenseInfoNodeResponse newNodeResponse() {
        return new LicenseInfoNodeResponse(this.clusterService.localNode(), null, null);
    }

    protected LicenseInfoResponse newResponse(LicenseInfoRequest request, List<LicenseInfoNodeResponse> responses, List<FailedNodeException> failures) {
        return new LicenseInfoResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected LicenseInfoNodeResponse nodeOperation(NodeLicenseRequest request) {
        SearchGuardLicense license = this.configurationRepository.getLicense();
        return new LicenseInfoNodeResponse(this.clusterService.localNode(), license, ReflectionHelper.getModulesLoaded());
    }

    protected NodeLicenseRequest newNodeRequest(LicenseInfoRequest request) {
        return new NodeLicenseRequest(request);
    }

    public static class NodeLicenseRequest
    extends BaseNodeRequest {
        LicenseInfoRequest request;

        public NodeLicenseRequest() {
        }

        public NodeLicenseRequest(LicenseInfoRequest request) {
            this.request = request;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new LicenseInfoRequest();
            this.request.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

