/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.whoami;

import com.floragunn.searchguard.action.whoami.WhoAmIRequest;
import com.floragunn.searchguard.action.whoami.WhoAmIResponse;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportWhoAmIAction
extends HandledTransportAction<WhoAmIRequest, WhoAmIResponse> {
    private final AdminDNs adminDNs;
    private final ThreadPool threadPool;

    @Inject
    public TransportWhoAmIAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, AdminDNs adminDNs, ActionFilters actionFilters) {
        super("cluster:admin/searchguard/whoami", transportService, actionFilters, WhoAmIRequest::new);
        this.adminDNs = adminDNs;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, WhoAmIRequest request, ActionListener<WhoAmIResponse> listener) {
        User user = (User)this.threadPool.getThreadContext().getTransient("_sg_user");
        String dn = user == null ? (String)this.threadPool.getThreadContext().getTransient("_sg_ssl_transport_principal") : user.getName();
        boolean isAdmin = this.adminDNs.isAdminDN(dn);
        boolean isAuthenticated = isAdmin ? true : user != null;
        boolean isNodeCertificateRequest = HeaderHelper.isInterClusterRequest(this.threadPool.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.threadPool.getThreadContext());
        listener.onResponse((Object)new WhoAmIResponse(dn, isAdmin, isAuthenticated, isNodeCertificateRequest));
    }
}

