/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.AuthDomain;
import com.floragunn.searchguard.auth.AuthFailureListener;
import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.auth.AuthorizationBackend;
import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.auth.UserInjector;
import com.floragunn.searchguard.auth.blocking.ClientBlockRegistry;
import com.floragunn.searchguard.auth.internal.NoOpAuthenticationBackend;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.http.XFFResolver;
import com.floragunn.searchguard.sgconf.ConfigModel;
import com.floragunn.searchguard.sgconf.DynamicConfigFactory;
import com.floragunn.searchguard.sgconf.DynamicConfigModel;
import com.floragunn.searchguard.sgconf.InternalUsersModel;
import com.floragunn.searchguard.ssl.util.Utils;
import com.floragunn.searchguard.support.HTTPHelper;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class BackendRegistry
implements DynamicConfigFactory.DCFListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private SortedSet<AuthDomain> restAuthDomains;
    private Set<AuthorizationBackend> restAuthorizers;
    private SortedSet<AuthDomain> transportAuthDomains;
    private Set<AuthorizationBackend> transportAuthorizers;
    private List<AuthFailureListener> ipAuthFailureListeners;
    private Multimap<String, AuthFailureListener> authBackendFailureListeners;
    private List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries;
    private Multimap<String, ClientBlockRegistry<String>> authBackendClientBlockRegistries;
    private volatile boolean initialized;
    private final AdminDNs adminDns;
    private final XFFResolver xffResolver;
    private volatile boolean anonymousAuthEnabled = false;
    private final Settings esSettings;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private final UserInjector userInjector;
    private final int ttlInMin;
    private Cache<AuthCredentials, User> userCache;
    private Cache<String, User> restImpersonationCache;
    private Cache<String, User> userCacheTransport;
    private Cache<AuthCredentials, User> authenticatedUserCacheTransport;
    private Cache<User, Set<String>> transportRoleCache;
    private Cache<User, Set<String>> restRoleCache;
    private Cache<String, User> transportImpersonationCache;
    private volatile String transportUsernameAttribute = null;

    private void createCaches() {
        this.userCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
        this.userCacheTransport = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(){

            public void onRemoval(RemovalNotification<String, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.authenticatedUserCacheTransport = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
        this.restImpersonationCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(){

            public void onRemoval(RemovalNotification<String, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.transportRoleCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<User, Set<String>>(){

            public void onRemoval(RemovalNotification<User, Set<String>> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.restRoleCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<User, Set<String>>(){

            public void onRemoval(RemovalNotification<User, Set<String>> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.transportImpersonationCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(){

            public void onRemoval(RemovalNotification<String, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
    }

    public BackendRegistry(Settings settings, AdminDNs adminDns, XFFResolver xffResolver, AuditLog auditLog, ThreadPool threadPool) {
        this.adminDns = adminDns;
        this.esSettings = settings;
        this.xffResolver = xffResolver;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.ttlInMin = settings.getAsInt("searchguard.cache.ttl_minutes", Integer.valueOf(60));
        this.createCaches();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void invalidateCache() {
        this.userCache.invalidateAll();
        this.userCacheTransport.invalidateAll();
        this.authenticatedUserCacheTransport.invalidateAll();
        this.restImpersonationCache.invalidateAll();
        this.restRoleCache.invalidateAll();
        this.transportRoleCache.invalidateAll();
        this.transportImpersonationCache.invalidateAll();
    }

    @Override
    public void onChanged(ConfigModel cm, DynamicConfigModel dcm, InternalUsersModel ium) {
        this.invalidateCache();
        this.transportUsernameAttribute = dcm.getTransportUsernameAttribute();
        this.anonymousAuthEnabled = dcm.isAnonymousAuthenticationEnabled() && this.esSettings.getAsBoolean("searchguard.compliance.disable_anonymous_authentication", Boolean.valueOf(false)) == false;
        this.restAuthDomains = Collections.unmodifiableSortedSet(dcm.getRestAuthDomains());
        this.transportAuthDomains = Collections.unmodifiableSortedSet(dcm.getTransportAuthDomains());
        this.restAuthorizers = Collections.unmodifiableSet(dcm.getRestAuthorizers());
        this.transportAuthorizers = Collections.unmodifiableSet(dcm.getTransportAuthorizers());
        this.ipAuthFailureListeners = dcm.getIpAuthFailureListeners();
        this.authBackendFailureListeners = dcm.getAuthBackendFailureListeners();
        this.ipClientBlockRegistries = dcm.getIpClientBlockRegistries();
        this.authBackendClientBlockRegistries = dcm.getAuthBackendClientBlockRegistries();
        this.initialized = !this.restAuthDomains.isEmpty() || this.anonymousAuthEnabled;
    }

    public User authenticate(TransportRequest request, String sslPrincipal, Task task, String action) {
        if (this.log.isDebugEnabled() && request.remoteAddress() != null) {
            this.log.debug("Transport authentication request from {}", (Object)request.remoteAddress());
        }
        if (request.remoteAddress() != null && this.isBlocked(request.remoteAddress().address().getAddress())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Rejecting transport request because of blocked address: " + request.remoteAddress());
            }
            return null;
        }
        User origPKIUser = new User(sslPrincipal);
        if (this.adminDns.isAdmin(origPKIUser)) {
            this.auditLog.logSucceededLogin(origPKIUser.getName(), true, null, request, action, task);
            return origPKIUser;
        }
        if (!this.isInitialized()) {
            this.log.error("Not yet initialized (you may need to run sgadmin)");
            return null;
        }
        String authorizationHeader = this.threadPool.getThreadContext().getHeader("Authorization");
        AuthCredentials creds = HTTPHelper.extractCredentials(authorizationHeader, this.log);
        User impersonatedTransportUser = null;
        if (creds != null && this.log.isDebugEnabled()) {
            this.log.debug("User {} submitted also basic credentials: {}", (Object)origPKIUser.getName(), (Object)creds);
        }
        for (AuthDomain authDomain : this.transportAuthDomains) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Check transport authdomain {}/{} or {} in total", (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), (Object)this.transportAuthDomains.size());
            }
            User authenticatedUser = null;
            if (creds == null) {
                impersonatedTransportUser = this.impersonate(request, origPKIUser);
                origPKIUser = this.resolveTransportUsernameAttribute(origPKIUser);
                authenticatedUser = this.checkExistsAndAuthz(this.userCacheTransport, impersonatedTransportUser == null ? origPKIUser : impersonatedTransportUser, authDomain.getBackend(), this.transportAuthorizers);
            } else {
                authenticatedUser = this.authcz(this.authenticatedUserCacheTransport, this.transportRoleCache, creds, authDomain.getBackend(), this.transportAuthorizers);
            }
            if (authenticatedUser == null) {
                for (AuthFailureListener authFailureListener : this.authBackendFailureListeners.get((Object)authDomain.getBackend().getClass().getName())) {
                    authFailureListener.onAuthFailure(request.remoteAddress() != null ? request.remoteAddress().address().getAddress() : null, creds, request);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Cannot authenticate transport user {} (or add roles) with authdomain {}/{} of {}, try next", (Object)(creds == null ? (impersonatedTransportUser == null ? origPKIUser.getName() : impersonatedTransportUser.getName()) : creds.getUsername()), (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), (Object)this.transportAuthDomains.size());
                continue;
            }
            if (this.adminDns.isAdmin(authenticatedUser)) {
                this.log.error("Cannot authenticate transport user because admin user is not permitted to login");
                this.auditLog.logFailedLogin(authenticatedUser.getName(), true, null, request, task);
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Transport user '{}' is authenticated", (Object)authenticatedUser);
            }
            this.auditLog.logSucceededLogin(authenticatedUser.getName(), false, impersonatedTransportUser == null ? null : origPKIUser.getName(), request, action, task);
            return authenticatedUser;
        }
        if (creds == null) {
            this.auditLog.logFailedLogin(impersonatedTransportUser == null ? origPKIUser.getName() : impersonatedTransportUser.getName(), false, impersonatedTransportUser == null ? null : origPKIUser.getName(), request, task);
        } else {
            this.auditLog.logFailedLogin(creds.getUsername(), false, null, request, task);
        }
        this.log.warn("Transport authentication finally failed for {} from {}", (Object)(creds == null ? (impersonatedTransportUser == null ? origPKIUser.getName() : impersonatedTransportUser.getName()) : creds.getUsername()), (Object)request.remoteAddress());
        this.notifyIpAuthFailureListeners(request.remoteAddress() != null ? request.remoteAddress().address().getAddress() : null, creds, request);
        return null;
    }

    public boolean authenticate(RestRequest request, RestChannel channel, org.elasticsearch.common.util.concurrent.ThreadContext threadContext) {
        if (request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress && this.isBlocked(request.getHttpChannel().getRemoteAddress().getAddress())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Rejecting REST request because of blocked address: " + request.getHttpChannel().getRemoteAddress());
            }
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication finally failed"));
            return false;
        }
        String sslPrincipal = (String)this.threadPool.getThreadContext().getTransient("_sg_ssl_principal");
        if (this.adminDns.isAdminDN(sslPrincipal)) {
            this.threadPool.getThreadContext().putTransient("_sg_user", (Object)new User(sslPrincipal));
            this.auditLog.logSucceededLogin(sslPrincipal, true, null, request);
            return true;
        }
        if (this.userInjector.injectUser(request)) {
            return true;
        }
        if (!this.isInitialized()) {
            this.log.error("Not yet initialized (you may need to run sgadmin)");
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "Search Guard not initialized (SG11). See https://docs.search-guard.com/latest/sgadmin"));
            return false;
        }
        TransportAddress remoteAddress = this.xffResolver.resolve(request);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Rest authentication request from {} [original: {}]", (Object)remoteAddress, (Object)request.getHttpChannel().getRemoteAddress());
        }
        threadContext.putTransient("_sg_remote_address", (Object)remoteAddress);
        boolean authenticated = false;
        User authenticatedUser = null;
        AuthCredentials authCredenetials = null;
        HTTPAuthenticator firstChallengingHttpAuthenticator = null;
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthCredentials ac;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Check authdomain for rest {}/{} or {} in total", (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), (Object)this.restAuthDomains.size());
            }
            HTTPAuthenticator httpAuthenticator = authDomain.getHttpAuthenticator();
            if (authDomain.isChallenge() && firstChallengingHttpAuthenticator == null) {
                firstChallengingHttpAuthenticator = httpAuthenticator;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Try to extract auth creds from {} http authenticator", (Object)httpAuthenticator.getType());
            }
            try {
                ac = httpAuthenticator.extractCredentials(request, threadContext);
            }
            catch (Exception e1) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("'{}' extracting credentials from {} http authenticator", (Object)e1.toString(), (Object)httpAuthenticator.getType(), (Object)e1);
                continue;
            }
            if (ac != null && this.isBlocked(authDomain.getBackend().getClass().getName(), ac.getUsername())) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Rejecting REST request because of blocked user: " + ac.getUsername() + "; authDomain: " + authDomain);
                continue;
            }
            authCredenetials = ac;
            if (ac == null) {
                if (this.anonymousAuthEnabled) continue;
                if (authDomain.isChallenge() && httpAuthenticator.reRequestAuthentication(channel, null)) {
                    this.auditLog.logFailedLogin("<NONE>", false, null, request);
                    this.log.trace("No 'Authorization' header, send 401 and 'WWW-Authenticate Basic'");
                    return false;
                }
                this.log.trace("No 'Authorization' header, send 403");
                continue;
            }
            ThreadContext.put((String)"user", (String)ac.getUsername());
            if (!ac.isComplete()) {
                if (!httpAuthenticator.reRequestAuthentication(channel, ac)) continue;
                return false;
            }
            authenticatedUser = this.authcz(this.userCache, this.restRoleCache, ac, authDomain.getBackend(), this.restAuthorizers);
            if (authenticatedUser == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cannot authenticate rest user {} (or add roles) with authdomain {}/{} of {}, try next", (Object)ac.getUsername(), (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), this.restAuthDomains);
                }
                for (AuthFailureListener authFailureListener : this.authBackendFailureListeners.get((Object)authDomain.getBackend().getClass().getName())) {
                    authFailureListener.onAuthFailure(request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress ? request.getHttpChannel().getRemoteAddress().getAddress() : null, ac, request);
                }
                continue;
            }
            if (this.adminDns.isAdmin(authenticatedUser)) {
                this.log.error("Cannot authenticate rest user because admin user is not permitted to login via HTTP");
                this.auditLog.logFailedLogin(authenticatedUser.getName(), true, null, request);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Cannot authenticate user because admin user is not permitted to login via HTTP"));
                return false;
            }
            String tenant = Utils.coalesce(request.header("sgtenant"), request.header("sg_tenant"));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Rest user '{}' is authenticated", (Object)authenticatedUser);
                this.log.debug("sgtenant '{}'", (Object)tenant);
            }
            authenticatedUser.setRequestedTenant(tenant);
            authenticated = true;
            break;
        }
        if (!authenticated) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("User still not authenticated after checking {} auth domains", (Object)this.restAuthDomains.size());
            }
            if (authCredenetials == null && this.anonymousAuthEnabled) {
                threadContext.putTransient("_sg_user", (Object)User.ANONYMOUS);
                this.auditLog.logSucceededLogin(User.ANONYMOUS.getName(), false, null, request);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Anonymous User is authenticated");
                }
                return true;
            }
            if (firstChallengingHttpAuthenticator != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rerequest with {}", firstChallengingHttpAuthenticator.getClass());
                }
                if (firstChallengingHttpAuthenticator.reRequestAuthentication(channel, null)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rerequest {} failed", firstChallengingHttpAuthenticator.getClass());
                    }
                    this.log.warn("Authentication finally failed for {} from {}", (Object)(authCredenetials == null ? null : authCredenetials.getUsername()), (Object)remoteAddress);
                    this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), false, null, request);
                    this.notifyIpAuthFailureListeners(request, authCredenetials);
                    return false;
                }
            }
            this.log.warn("Authentication finally failed for {} from {}", (Object)(authCredenetials == null ? null : authCredenetials.getUsername()), (Object)remoteAddress);
            this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), false, null, request);
            this.notifyIpAuthFailureListeners(request, authCredenetials);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication finally failed"));
            return false;
        }
        User impersonatedUser = this.impersonate(request, authenticatedUser);
        threadContext.putTransient("_sg_user", (Object)(impersonatedUser == null ? authenticatedUser : impersonatedUser));
        this.auditLog.logSucceededLogin((impersonatedUser == null ? authenticatedUser : impersonatedUser).getName(), false, authenticatedUser.getName(), request);
        return authenticated;
    }

    private void notifyIpAuthFailureListeners(RestRequest request, AuthCredentials authCredentials) {
        this.notifyIpAuthFailureListeners(request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress ? request.getHttpChannel().getRemoteAddress().getAddress() : null, authCredentials, request);
    }

    private void notifyIpAuthFailureListeners(InetAddress remoteAddress, AuthCredentials authCredentials, Object request) {
        for (AuthFailureListener authFailureListener : this.ipAuthFailureListeners) {
            authFailureListener.onAuthFailure(remoteAddress, authCredentials, request);
        }
    }

    private User checkExistsAndAuthz(Cache<String, User> cache, final User user, final AuthenticationBackend authenticationBackend, final Set<AuthorizationBackend> authorizers) {
        if (user == null) {
            return null;
        }
        try {
            return (User)cache.get((Object)user.getName(), (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (BackendRegistry.this.log.isTraceEnabled()) {
                        BackendRegistry.this.log.trace("Credentials for user " + user.getName() + " not cached, return from " + authenticationBackend.getType() + " backend directly");
                    }
                    if (authenticationBackend.exists(user)) {
                        BackendRegistry.this.authz(user, (Cache<User, Set<String>>)null, authorizers);
                        return user;
                    }
                    if (BackendRegistry.this.log.isDebugEnabled()) {
                        BackendRegistry.this.log.debug("User " + user.getName() + " does not exist in " + authenticationBackend.getType());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Can not check and authorize " + user.getName() + " due to " + e.toString(), (Throwable)e);
            }
            return null;
        }
    }

    private void authz(User authenticatedUser, Cache<User, Set<String>> roleCache, Set<AuthorizationBackend> authorizers) {
        Set cachedBackendRoles;
        if (authenticatedUser == null) {
            return;
        }
        if (roleCache != null && (cachedBackendRoles = (Set)roleCache.getIfPresent((Object)authenticatedUser)) != null) {
            authenticatedUser.addRoles(new HashSet<String>(cachedBackendRoles));
            return;
        }
        if (authorizers == null || authorizers.isEmpty()) {
            return;
        }
        for (AuthorizationBackend ab : authorizers) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Backend roles for " + authenticatedUser.getName() + " not cached, return from " + ab.getType() + " backend directly");
                }
                ab.fillRoles(authenticatedUser, new AuthCredentials(authenticatedUser.getName(), new String[0]));
            }
            catch (Exception e) {
                this.log.error("Cannot retrieve roles for {} from {} due to {}", (Object)authenticatedUser, (Object)ab.getType(), (Object)e.toString(), (Object)e);
            }
        }
        if (roleCache != null) {
            roleCache.put((Object)authenticatedUser, new HashSet<String>(authenticatedUser.getRoles()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User authcz(Cache<AuthCredentials, User> cache, final Cache<User, Set<String>> roleCache, final AuthCredentials ac, final AuthenticationBackend authBackend, final Set<AuthorizationBackend> authorizers) {
        if (ac == null) {
            return null;
        }
        try {
            if (authBackend.getClass() == NoOpAuthenticationBackend.class && authorizers.isEmpty()) {
                User user = authBackend.authenticate(ac);
                return user;
            }
            User user = (User)cache.get((Object)ac, (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (BackendRegistry.this.log.isTraceEnabled()) {
                        BackendRegistry.this.log.trace("Credentials for user " + ac.getUsername() + " not cached, return from " + authBackend.getType() + " backend directly");
                    }
                    User authenticatedUser = authBackend.authenticate(ac);
                    BackendRegistry.this.authz(authenticatedUser, (Cache<User, Set<String>>)roleCache, authorizers);
                    return authenticatedUser;
                }
            });
            return user;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Can not authenticate " + ac.getUsername() + " due to " + e.toString(), (Throwable)e);
            }
            User user = null;
            return user;
        }
        finally {
            ac.clearSecrets();
        }
    }

    private User impersonate(TransportRequest tr, User origPKIuser) throws ElasticsearchSecurityException {
        String impersonatedUser = this.threadPool.getThreadContext().getHeader("sg_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUser)) {
            return null;
        }
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Could not check for impersonation because Search Guard is not yet initialized", new Object[0]);
        }
        if (origPKIuser == null) {
            throw new ElasticsearchSecurityException("no original PKI user found", new Object[0]);
        }
        User aU = origPKIuser;
        if (this.adminDns.isAdminDN(impersonatedUser)) {
            throw new ElasticsearchSecurityException("'" + origPKIuser.getName() + "' is not allowed to impersonate as an adminuser  '" + impersonatedUser + "'", new Object[0]);
        }
        try {
            if (impersonatedUser != null && !this.adminDns.isTransportImpersonationAllowed(new LdapName(origPKIuser.getName()), impersonatedUser)) {
                throw new ElasticsearchSecurityException("'" + origPKIuser.getName() + "' is not allowed to impersonate as transport user '" + impersonatedUser + "'", new Object[0]);
            }
            if (impersonatedUser != null) {
                for (AuthDomain authDomain : this.transportAuthDomains) {
                    AuthenticationBackend authenticationBackend = authDomain.getBackend();
                    User impersonatedUserObject = this.checkExistsAndAuthz(this.transportImpersonationCache, new User(impersonatedUser), authenticationBackend, this.transportAuthorizers);
                    if (impersonatedUserObject == null) {
                        this.log.debug("Unable to impersonate transport user from '{}' to '{}' because the impersonated user does not exists in {}, try next ...", (Object)origPKIuser.getName(), (Object)impersonatedUser, (Object)authenticationBackend.getType());
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Impersonate transport user from '{}' to '{}'", (Object)origPKIuser.getName(), (Object)impersonatedUser);
                    }
                    return impersonatedUserObject;
                }
                this.log.debug("Unable to impersonate transport user from '{}' to '{}' because the impersonated user does not exists", (Object)origPKIuser.getName(), (Object)impersonatedUser);
                throw new ElasticsearchSecurityException("No such transport user: " + impersonatedUser, RestStatus.FORBIDDEN, new Object[0]);
            }
        }
        catch (InvalidNameException e1) {
            throw new ElasticsearchSecurityException("PKI does not have a valid name ('" + origPKIuser.getName() + "'), should never happen", (Exception)e1, new Object[0]);
        }
        return aU;
    }

    private User impersonate(RestRequest request, User originalUser) throws ElasticsearchSecurityException {
        String impersonatedUserHeader = request.header("sg_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUserHeader) || originalUser == null) {
            return null;
        }
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Could not check for impersonation because Search Guard is not yet initialized", new Object[0]);
        }
        if (this.adminDns.isAdminDN(impersonatedUserHeader)) {
            throw new ElasticsearchSecurityException("It is not allowed to impersonate as an adminuser  '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!this.adminDns.isRestImpersonationAllowed(originalUser.getName(), impersonatedUserHeader)) {
            throw new ElasticsearchSecurityException("'" + originalUser.getName() + "' is not allowed to impersonate as '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthenticationBackend authenticationBackend = authDomain.getBackend();
            User impersonatedUser = this.checkExistsAndAuthz(this.restImpersonationCache, new User(impersonatedUserHeader), authenticationBackend, this.restAuthorizers);
            if (impersonatedUser == null) {
                this.log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists in {}, try next ...", (Object)originalUser.getName(), (Object)impersonatedUserHeader, (Object)authenticationBackend.getType());
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Impersonate rest user from '{}' to '{}'", (Object)originalUser.toStringWithAttributes(), (Object)impersonatedUser.toStringWithAttributes());
            }
            impersonatedUser.setRequestedTenant(originalUser.getRequestedTenant());
            return impersonatedUser;
        }
        this.log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists", (Object)originalUser.getName(), (Object)impersonatedUserHeader);
        throw new ElasticsearchSecurityException("No such user:" + impersonatedUserHeader, RestStatus.FORBIDDEN, new Object[0]);
    }

    private User resolveTransportUsernameAttribute(User pkiUser) {
        if (this.transportUsernameAttribute != null && !this.transportUsernameAttribute.isEmpty()) {
            try {
                LdapName sslPrincipalAsLdapName = new LdapName(pkiUser.getName());
                for (Rdn rdn : sslPrincipalAsLdapName.getRdns()) {
                    if (!rdn.getType().equals(this.transportUsernameAttribute)) continue;
                    return new User((String)rdn.getValue());
                }
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
        return pkiUser;
    }

    private boolean isBlocked(InetAddress address) {
        if (this.ipClientBlockRegistries == null || this.ipClientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry<InetAddress> clientBlockRegistry : this.ipClientBlockRegistries) {
            if (!clientBlockRegistry.isBlocked(address)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlocked(String authBackend, String userName) {
        if (this.authBackendClientBlockRegistries == null) {
            return false;
        }
        Collection clientBlockRegistries = this.authBackendClientBlockRegistries.get((Object)authBackend);
        if (clientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry clientBlockRegistry : clientBlockRegistries) {
            if (!clientBlockRegistry.isBlocked(userName)) continue;
            return true;
        }
        return false;
    }
}

