/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.http.XFFResolver;
import com.floragunn.searchguard.support.SgUtils;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class UserInjector {
    protected final Logger log = LogManager.getLogger(UserInjector.class);
    private final ThreadPool threadPool;
    private final AuditLog auditLog;
    private final XFFResolver xffResolver;
    private final Boolean injectUserEnabled;

    UserInjector(Settings settings, ThreadPool threadPool, AuditLog auditLog, XFFResolver xffResolver) {
        this.threadPool = threadPool;
        this.auditLog = auditLog;
        this.xffResolver = xffResolver;
        this.injectUserEnabled = settings.getAsBoolean("searchguard.unsupported.inject_user.enabled", Boolean.valueOf(false));
    }

    boolean injectUser(RestRequest request) {
        if (!this.injectUserEnabled.booleanValue()) {
            return false;
        }
        String injectedUserString = (String)this.threadPool.getThreadContext().getTransient("injected_user");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injected user string: {}", (Object)injectedUserString);
        }
        if (Strings.isNullOrEmpty((String)injectedUserString)) {
            return false;
        }
        String[] parts = injectedUserString.split("\\|");
        if (parts.length == 0) {
            this.log.error("User string malformed, could not extract parts. User string was '{}.' User injection failed.", (Object)injectedUserString);
            return false;
        }
        if (Strings.isNullOrEmpty((String)parts[0])) {
            this.log.error("Username must not be null, user string was '{}.' User injection failed.", (Object)injectedUserString);
            return false;
        }
        User user = new User(parts[0]);
        if (parts.length > 1 && !Strings.isNullOrEmpty((String)parts[1]) && parts[1].length() > 0) {
            user.addRoles(Arrays.asList(parts[1].split(",")));
        }
        if (parts.length > 3 && !Strings.isNullOrEmpty((String)parts[3])) {
            Map<String, String> attributes = SgUtils.mapFromArray(parts[3].split(","));
            if (attributes == null) {
                this.log.error("Could not parse custom attributes {}, user injection failed.", (Object)parts[3]);
                return false;
            }
            user.addAttributes(attributes);
        }
        if (parts.length > 4 && !Strings.isNullOrEmpty((String)parts[4])) {
            user.setRequestedTenant(parts[4]);
        }
        if (parts.length > 2 && !Strings.isNullOrEmpty((String)parts[2])) {
            String[] ipAndPort = parts[2].split(":");
            if (ipAndPort.length != 2) {
                this.log.error("Remote address must have format ip:port, was: {}. User injection failed.", (Object)parts[2]);
                return false;
            }
            try {
                InetAddress iAdress = InetAddress.getByName(ipAndPort[0]);
                int port = Integer.parseInt(ipAndPort[1]);
                this.threadPool.getThreadContext().putTransient("_sg_remote_address", (Object)new TransportAddress(iAdress, port));
            }
            catch (NumberFormatException | UnknownHostException e) {
                this.log.error("Cannot parse remote IP or port: {}, user injection failed.", (Object)parts[2], (Object)e);
                return false;
            }
        } else {
            this.threadPool.getThreadContext().putTransient("_sg_remote_address", (Object)this.xffResolver.resolve(request));
        }
        user.setInjected(true);
        this.threadPool.getThreadContext().putTransient("_sg_user", (Object)user);
        this.auditLog.logSucceededLogin(parts[0], true, null, request);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Injected user object:{} ", (Object)user.toString());
        }
        return true;
    }
}

